<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Voucher;
use App\Models\Notification;

use Carbon\Carbon;

class DeactivateExpiredVouchers extends Command
{
    protected $signature = 'vouchers:deactivate-expired';

    protected $description = 'Deactivate vouchers that have passed their expiration date';

    public function handle()
    {
        $today = Carbon::today();

        $expiredVouchers = Voucher::where('is_active', 1)
            ->whereDate('expiration_date', '<', $today)
            ->get();

        if ($expiredVouchers->isEmpty()) {
            $this->info('No expired vouchers found.');
            return Command::SUCCESS;
        }

        foreach ($expiredVouchers as $voucher) {
            $voucher->update(['is_active' => 0]);

            $this->info("Voucher deactivated: {$voucher->code}");

            Notification::create([
                'type' => 'voucher_expired',
                'status' => 'Voucher Expired',
                'is_read' => false,

                'customer_name' => 'System',
                'customer_email' => '—',
                'customer_phone' => '—',

                'data' => [
                    [
                        'label' => 'voucher_code',
                        'value' => $voucher->code,
                    ],
                    [
                        'label' => 'expiration_date',
                        'value' => $voucher->expiration_date->format('d.m.Y'),
                    ],
                ],
            ]);
        }

        return Command::SUCCESS;
    }
}
