<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\BookingItem;
use Carbon\Carbon;
use App\Models\ProductVariationOption;

class UpdateProductQuantities extends Command
{
    protected $signature = 'products:update-quantities';
    protected $description = 'Update product quantities when dropoff dates pass';

    public function handle()
    {
        $now = Carbon::now();

      
        $items = BookingItem::where(function($query) use ($now) {
            $query->where(function($q) use ($now) {
                $q->where('delay', '!=', 1)
                  ->where(function($sub) use ($now) {
                      $sub->where('dropoff_date', '<=', $now->toDateString())
                          ->where('dropoff_time', '<=', $now->toTimeString())
                          ->orWhere('dropoff_date', '<', $now->toDateString());
                  });
            })
            ->orWhere(function($q) use ($now) {
                $q->where('delay', 1)
                  ->where(function($sub) use ($now) {
                    $sub->where('new_dropoff_date', '<=', $now->toDateString())
                          ->where('new_dropoff_time', '<=', $now->toTimeString())
                          ->orWhere('new_dropoff_date', '<', $now->toDateString());

                  });
            });
        })
        ->where('damage', '!=', 1)
        ->where('already_booked','=', 0)
        ->where('status', 'confirmed')
        // ->where('quantity_restored', false)
        ->get();
        
    
        foreach ($items as $item) {
            $success = $this->updateProductQuantity(
                $item->product_id,
                $item->color,
                $item->size,
                1,
                $item->vendor_id
            );
    
            if ($success) {
                $item->status = 'completed';
                $item->save();
            }
        }
        // $this->info($items);
        $this->info('Updated quantities for ' . $items->count() . ' products');
    }
    
    protected function updateProductQuantity($productId, $colorName, $sizeName, $change,$vendorId = null)
    {
        $color = \App\Models\Color::where('name', $colorName)->first();
        if (!$color) {
            $this->error("Color not found: {$colorName}");
            return false;
        }
    
        $size = \App\Models\Size::where('name', $sizeName)->first();
        $variation = \App\Models\Variation::where('name', $sizeName)->first();
    
        $query = \App\Models\ProductVariationOption::whereHas('variation', function($query) use ($productId, $size, $variation) {
                $query->where('product_id', $productId)
                      ->where(function($q) use ($size, $variation) {
                          if ($size) $q->where('size_id', $size->id);
                          if ($variation) $q->orWhere('variation_id', $variation->id);
                      });
            })
            ->where('color_id', $color->id);
    
        $option = $query->first();
    
        if (!$option) {
            $this->error("Variation option not found for product: {$productId}, color: {$colorName}, size: {$sizeName}");
            return false;
        }

        if (!empty($vendorId)) {
            $vendorQty = \App\Models\VendorProductQuantity::where('vendor_id', $vendorId)
                ->where('product_variation_option_id', $option->id)
                ->first();
    
            if ($vendorQty) {
                $vendorQty->quantity += $change;
                $vendorQty->save();
                return true;
            }
        } else {
            $option->quantity += $change;
            $option->save();
            return true;
        }
    
       
    }
}