<?php

namespace App\Exports;

use App\Models\Bundle;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithCustomStartCell;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Maatwebsite\Excel\Concerns\WithColumnWidths;

class BundleFileExport implements FromCollection, WithHeadings, WithCustomStartCell, WithStyles, WithColumnFormatting, WithColumnWidths
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Bundle::select([
            'car_make',
            'model',
            'type_year',
            'rooftype_ger',
            'rooftype_eng',
            'recommended_roofbox_size',
            'carrier_length',
            'foot_sku',
            'footkit_sku',
            'product_category',
            'bundle_name',
            'description'
        ])->get();
    }

    /**
     * @return array
     */
    public function headings(): array
    {
        return [
            'Car Make',
            'Model',
            'Type/Year',
            'Rooftype GER',
            'Rooftype ENG',
            'Recommended Roofbox Size',
            'Carrier Length',
            "Foot\nSKU",
            "Foot Kit\nSKU",
            'Product Category',
            'Bundle Name',
            'Description',
            'Old Kit 753 Foot'
        ];
    }

    /**
     * @return string
     */
    public function startCell(): string
    {
        return 'A2';
    }

    /**
     * @return array
     */
    public function styles(Worksheet $sheet)
    {
        // Add the special header rows
        $sheet->setCellValue('D1', 'Roof Type Name');
        $sheet->setCellValue('H1', 'Roof Rack');
        $sheet->setCellValue('L1', 'ignore');
        
        return [
            'D1' => ['font' => ['bold' => true]],
            'H1' => ['font' => ['bold' => true]],
            'L1' => ['font' => ['bold' => true]],
            
            // Style for column headers (row 3)
            'A3:L3' => [
                'font' => ['bold' => true],
                'alignment' => [
                    'wrapText' => true,
                    'vertical' => 'center'
                ]
            ],
            
            'H3' => ['alignment' => ['wrapText' => true]],
            'I3' => ['alignment' => ['wrapText' => true]],
        ];
    }

    /**
     * @return array
     */
    public function columnFormats(): array
    {
        return [
            'G' => NumberFormat::FORMAT_TEXT,
        ];
    }

    /**
     * @return array
     */
    public function columnWidths(): array
    {
        return [
            'A' => 15, // Car Make
            'B' => 20, // Model
            'C' => 15, // Type/Year
            'D' => 25, // Rooftype GER
            'E' => 20, // Rooftype ENG
            'F' => 25, // Recommended Roofbox Size
            'G' => 15, // Carrier Length
            'H' => 10, // Foot SKU
            'I' => 12, // Foot Kit SKU
            'J' => 20,
            'K' => 40, // Bundle Name
            'L' => 30, // Description
            'M' => 15,
        ];
    }
}