<?php

namespace App\Exports;

use App\Models\Booking;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class PaymentsExport implements FromCollection, WithHeadings, WithMapping
{
    protected $bookings;

    public function __construct($bookings)
    {
        $this->bookings = $bookings;
    }

    public function collection()
    {
        return $this->bookings;
    }

    public function headings(): array
    {
        return [
            'Booking ID',
            'Payment ID',
            'Customer Name',
            'Email',
            'Date',
            'Payment Method',
            'Amount (€)',
            'Refund Amount (€)',
            'Status',
            'Created At'
        ];
    }

    public function map($booking): array
    {
        return [
            $booking->id,
            $booking->stripe_payment_intent ?? 'N/A',
            $booking->userDetails ? $booking->userDetails->first_name.' '.$booking->userDetails->last_name : 'N/A',
            $booking->userDetails ? $booking->userDetails->email : 'N/A',
            $booking->created_at->format('d.m.Y'),
            $booking->payment_method ?? 'N/A',
            number_format($booking->total, 2, ',', '.'), 
            number_format($booking->refund_amount, 2, ',', '.'), 
            $this->getStatusText($booking->payment_status),
            $booking->created_at->format('Y-m-d H:i:s')
        ];
    }

    private function getStatusText($status)
    {
        switch ($status) {
            case 'paid': return 'Completed';
            case 'unpaid': return 'Canceled';
            case 'refund': return 'Refunded';
            case 'reconciliation': return 'Reconciliation';
            default: return $status;
        }
    }
}