<?php 
use App\Models\AdditionalStatistician;
use App\Models\Category;
use App\Models\ContentManagement;
use App\Models\PageMetaTag;
use App\Models\Player;
use App\Models\VolleyballMatch;
use Stripe\Exception\SignatureVerificationException;
use Stripe\Webhook;

// Active Menu Function
function ActiveMenu($arr, $returnText) {
  $currentRoute = \Request::route()->getName();
    $i=0;
    for($j=0;$j<count($arr); $j++){
      if($arr[$j] == $currentRoute){
        $i++;
      }
    }
  return $i > 0 ? $returnText : '' ;
}

// Image Upload function create folder and move the image and return image name
function uploadImageFile($image, $dir, $old_image = ""){  
  $name = uniqid() . '.' .$image->getClientOriginalExtension();
  $filePath = $image->storeAs('uploads/'.$dir, $name, 'public');

  // Delete old image 
  if(!empty($old_image)){    
    $img_path = public_path('/storage/'.$old_image);
    if (file_exists($img_path) && $old_image != 'default.png') {
        unlink($img_path);
    }
  }
  // dd($filePath);
  return $filePath;
}

// Return Meta data
function GetMetaData($key,$page_type){
  $data = PageMetaTag::where(['key'=> $key, 'type'=> $page_type])->first();  
  if(!empty($data)){
    return $data->key_value;
  }
}

// Return slug into text
function SlugToText($slug){
  return ucwords(str_replace('-', ' ', $slug));
}

// Return text into slug
function createSlug($str, $delimiter = '-'){
  $slug = strtolower(trim(preg_replace('/[\s-]+/', $delimiter, preg_replace('/[^A-Za-z0-9-]+/', $delimiter, preg_replace('/[&]/', 'and', preg_replace('/[\']/', '', iconv('UTF-8', 'ASCII//TRANSLIT', $str))))), $delimiter));
  return $slug;
} 

//******************************************
// Update mate value
//******************************************
function updateMeta($key, $value, $page_type, $request){
  $chk = PageMetaTag::where(['key'=> $key, 'type'=> $page_type])->first();
    if(!empty($chk)) {
      $chk->key = $key;
      $old_image = $chk->key_value;
  }else{
    $chk = new PageMetaTag();
    $chk->key = $key;
    $old_image = "";
  }

  // Check if file exist
  if ($request->hasFile($key)) {

    $value = uploadImageFile($request->file($key), 'Settings', $old_image);
  
  }

  // Save value in db
  $chk->key_value = !empty($value) ? $value : "";
  $chk->type = $page_type;
  $chk->save();
}
//******************************************
// Update mate value End
//******************************************

// function GetContentData($slug){ 
//   $category_data = \App\Models\ContentManagement::where('slug',$slug)->first();
//   if(!empty($category_data)){
//     return $category_data;
//   } 
// }

if (!function_exists('admin_sidebar')) {
  function admin_sidebar($current_route){
    return [
      [
          'active' => $current_route === 'admin.dashboard' ? 'active' : '', // add active class when same route is open
          'route' => route('admin.dashboard'), // route name of link
          'link_name' => 'Dashboard', // this is name for link
          'icon' => 'fas fa-fw fa-tachometer-alt', //icon for link
          'is_dropdown' => false, // to create dropdown menu make its value true and if no dropdown menu then its value is false
          'dropdown_links' => [], //if dropdown value is false then its dropdown links array must be empty
      ],
      
      [
          'active' =>  $current_route === 'admin.user.index' ? 'active' : '',
          'route' => route('admin.user.index'),
          'link_name' => 'User Management',
          'icon' => 'fas fa-fw fa-chart-area',
          'is_dropdown' => false,
          'dropdown_links' => [],
      ],
      [
          'active' =>  $current_route === 'admin.content.index' ? 'active' : '', // for add active class on dropdown heading when any of dropdown links route open 
          'route' => route('admin.content.index'),
          'link_name' => 'Content Managment',
          'icon' => 'fas fa-fw fa-chart-area',
          'is_dropdown' => false,
          'dropdown_links' => [],
      ],
    
      [
          'active' => $current_route === 'admin.faq.index' ? 'active' : '',
          'route' => route('admin.faq.index'),
          'link_name' => 'FAQ Management',
          'icon' => 'fas fa-fw fa-wrench',
          'is_dropdown' => false,
          'dropdown_links' => [],
      ],
      [
        'active' => in_array($current_route, ['admin.page.index']) ? 'active' : '',
        'route' => '',
        'link_name' => 'Settings',
        'icon' => 'fas fa-fw fa-cog',
        'is_dropdown' => true,
        'dropdown_links' => [
            [
                'active' => $current_route === 'admin.page.index' ? 'active' : '',
                'route' => route('admin.page.index'),
                'link_name' => 'Page Settings'
            ],
            [
                'active' => $current_route === 'admin.page.general' ? 'active' : '',
                'route' => route('admin.page.general'),
                'link_name' => 'general Settings'
            ],
        ],
    ],

  ];
  }
  function reformatPrice($price)
    {
        // Remove currency symbol and replace commas with dots for decimal point
        $price = str_replace(' €', '', $price); // Remove the currency symbol
        $price = str_replace(',', '.', $price);  // Replace commas with dots for float

        // Convert the string to float and then format it back to a string with comma
        $priceFloat = (float) $price;
        $formattedPrice = number_format($priceFloat, 2, ',', '');

        return $formattedPrice . ' €'; 
    }
    function productLinks()
    {
        $categories = Category::select('name', 'slug')
            ->where('status', 1)
            ->whereHas('products') // Ensures only categories with products are fetched
            ->get();
    
        return $categories;
    }

    function getLegalContent($slug){
     $content = ContentManagement::where('slug', $slug)->first();
    return $content;
    }

    function getHeaderLink($page_type){
     $pageLinks = PageMetaTag::where('key', 'is_header')->where('type', $page_type)->first();
     return $pageLinks->key_value??"";
    }
    function getFooterLink($page_type){
     $pageLinks = PageMetaTag::where('key', 'is_footer')->where('type', $page_type)->first();
     return $pageLinks->key_value;
    }
   
}


