<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin;
use App\Models\WorkingHours;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\File;
use App\Models\Holidays;

class AdminController extends Controller
{
    public function dashboard()
    {
        return view('admin.dashboard.index');
    }

    public function profileView()
    {
        $admin = Auth::guard('admin')->user();
        $time = WorkingHours::where('admin_id', $admin->id)->get();
        $holidays = Holidays::where('admin_id', $admin->id)->get();
        $country_code = json_decode(File::get(public_path('country-codes.json')), true);

        return view('admin.auth.profile', compact('admin', 'time', 'holidays', 'country_code'));
    }

    public function editProfile()
    {
        $admin = Auth::guard('admin')->user();
        $country_code = json_decode(File::get(public_path('country-codes.json')), true);
        $times = WorkingHours::where('admin_id', $admin->id)->get();

        $admin  = Auth::guard('admin')->user();
        return view('admin.auth.edit-profile', compact('admin', 'country_code', 'times'));
    }

    public function updateProfile(Request $request, Admin $admin)
    {
        try {
// dd($request->all());
            $validator = Validator::make($request->all(), [
                'title' => 'required|string|max:255',
                'first_name' => 'required|string|max:255',
                'last_name' => 'required|string|max:255',
                'email' => 'required',
                'company_name' => 'required|string|max:255',
                'address' => 'required|string|max:255',
                'zip_code' => 'required|string|max:255',
                'city' => 'required|string|max:255',
                'state' => 'required|string|max:255',
                'country_code' => 'required|string',
                'number' => 'required|string',
                'tax_number' => 'required|string',
                'umsatzsteuer' => 'required|string',
                'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
            ]);


            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }
            
            if ($request->hasFile('image')) {
                $imagePath = $request->file('image')->store('Admin/ProfileImage', 'public');
                $admin->image = $imagePath;
            }
            $admin->title = $request->title;
            $admin->first_name = $request->first_name;
            $admin->last_name = $request->last_name;
            $admin->company_name = $request->company_name;
            $admin->address = $request->address;
            $admin->email =$request->email;
            $admin->zip_code = $request->zip_code;
            $admin->city = $request->city;
            $admin->state = $request->state;
            $admin->country_code = $request->country_code;
            $admin->number = $request->number;
            $admin->tax_number = $request->tax_number;
            $admin->umsatzsteuer = $request->umsatzsteuer;
            $admin->save();


            $dayMap = [
                'mo' => 'Monday',
                'di' => 'Tuesday',
                'mi' => 'Wednesday',
                'do' => 'Thursday',
                'fr' => 'Friday',
                'sa' => 'Saturday',
                'so' => 'Sunday',
            ];
            
            $closedDays = $request->input('day_closed', []);

            foreach ($dayMap as $short => $full) {
                $isClosed = in_array($short, $closedDays);

                WorkingHours::updateOrCreate(
                    ['admin_id' => $admin->id, 'day' => $full],
                    [
                        'open_time' => $isClosed ? null : ($request->input("{$short}_from") && $request->input("{$short}_to")
                            ? date('H:i', strtotime($request->input("{$short}_from"))) : null),
                        'close_time' => $isClosed ? null : ($request->input("{$short}_from") && $request->input("{$short}_to")
                            ? date('H:i', strtotime($request->input("{$short}_to"))) : null),
                    ]
                );
            }


            return redirect()->route('admin.profile')->with('success', 'Profile updated successfully');
            //code...
        } catch (\Throwable $th) {
            dd($th);
        }
    }

    public function getChangePassword()
    {
        return view('admin.auth.change-password');
    }

    public function updateChangePassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'old_password' => 'required',
            'new_password' => [
                'required',
                'min:8'
            ],
            'confirm_new_password' => 'required|same:new_password',
        ], [
            'old_password.required' => 'Please enter old password.',
            'new_password.required' => 'Please enter new password.',
            'new_password.min' => 'New password must be at least 8 characters long.',
            'confirm_new_password.required' => 'Please enter confirm new password.',
            'confirm_new_password.same' => 'New password and confirm new password does not match.',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $admin = Auth::guard('admin')->user();

        if (!Hash::check($request->old_password, $admin->password)) {
            return redirect()->back()->with('error', 'Please enter correct current password.');
        }

        $admin->password = Hash::make($request->new_password);
        $admin->save();

        return redirect()->route('admin.login')->with('success', 'Password changed successfully');
    }

    public function addHolidays(Request $request)
    {
        // Validate input
        $request->validate([
            'holiday_name' => 'required|string|max:255',
            'holiday_date' => 'required|date',
        ]);

        $admin = Auth::guard('admin')->user();
        $formattedDate = date('Y-m-d', strtotime($request->holiday_date));

        $existingHoliday = Holidays::where('admin_id', $admin->id)
            ->where('date', $formattedDate)
            ->first();

        if ($existingHoliday) {
            return redirect()->back()->with('error', 'A holiday on this date already exists.');
        }

        // Save the new holiday
        $holiday = new Holidays();
        $holiday->admin_id = $admin->id;
        $holiday->name = $request->holiday_name;
        $holiday->date = $formattedDate;
        $holiday->save();

        return redirect()->back()->with('success', 'Holiday added successfully!');
    }


    // Delete a holiday
    public function deleteHoliday($id)
    {
        try {
            $holiday = Holidays::findOrFail($id); // Find the holiday
            $holiday->delete(); // Delete it
            // return redirect()->back()->with('success', 'Holiday deleted successfully.');

            return response()->json(['success' => true, 'message' => 'Holiday deleted successfully.']);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'message' => $e->getMessage()], 500);
        }
    }
}
