<?php

namespace App\Http\Controllers\Admin\Blog;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Blog;
use Illuminate\Support\Facades\Validator;

class BlogController extends Controller
{
    public function index()
    {
        $contents = Blog::orderBy('id', 'desc')->get();
        return view('admin.blog.index', compact('contents'));
    }

    public function view(Request $request)
    {

        return view('admin.blog.create');
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:5000',
            'description' => 'required|string',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $image = "";
        if ($request->hasFile('image')) {
            $image = uploadImageFile($request->file('image'), 'Admin/ProfileImage', null);
        }

        Blog::create([
            'title' => $request->title,
            'description' => $request->description,
            'image' => $image,
        ]);

        return redirect()->route('admin.blog.index')->with('success', 'Content created successfully.');
    }

    public function edit(Request $request, Blog $content)
    {

        return view('admin.blog.edit', compact('content'));
    }

    public function update(Request $request, Blog $content)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'description' => 'required|string',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        if ($request->hasFile('image')) {
            $content->image = uploadImageFile($request->file('image'), 'Admin/ProfileImage', null);
        }

        $content->title = $request->title;
        $content->description = $request->description;
        $content->save();
        return redirect()->route('admin.blog.index')->with('success', 'Blog updated successfully.');
    }

    public function deleteBlog(Request $request)
    {
        try {
            $blog_id = $request->blog_id;
           $contents = Blog::where('id', $blog_id)->first();
            $contents->delete();

            return redirect()->back()->with('success', 'Blog deleted successfully!');
        } catch (\Exception $e) {
            dd($e->getMessage());
            return redirect()->back()->with('error', 'Something went wrong! Please try again later.');
        }
    }
}
