<?php

namespace App\Http\Controllers\Admin\Category;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use Exception;
use Illuminate\Support\Facades\Validator;

class CategoryController extends Controller
{
    public $file_path = 'admin.category.';

    public function getAll()
    {
        try {
            $categories = Category::all();
            return view($this->file_path . 'index', compact('categories'));
        } catch (Exception $e) {
            dd($e->getMessage());
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function addView()
    {
        try {
            $colors = \App\Models\Color::all();
            $sizes = \App\Models\Size::all();
            $variations = \App\Models\Variation::all();
            return view($this->file_path . 'add', compact('colors', 'sizes', 'variations'));
        } catch (Exception $e) {
            dd($e->getMessage());
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function add(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'name' => 'required|string|max:255|unique:categories,name',
                'color_ids' => 'nullable|array',
                'size_ids' => 'nullable|array',
                'variation_ids' => 'nullable|array',
            ]);

            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $validatedData = $validator->validated();

            $category = \App\Models\Category::create([
                'name' => $validatedData['name'],
                'color_ids' => $validatedData['color_ids'] ?? [],
                'size_ids' => $validatedData['size_ids'] ?? [],
                'variation_ids' => $validatedData['variation_ids'] ?? [],
            ]);

            return redirect()->route('admin.category.index')->with('success', 'Category successfully added.');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function edit($slug)
    {
        $category = Category::where('slug', $slug)->firstOrFail();
        $colors = \App\Models\Color::all();
        $sizes = \App\Models\Size::all();
        $variations = \App\Models\Variation::all();
    
        return view($this->file_path . 'edit', compact('category', 'colors', 'sizes', 'variations'));
    }
    

    public function update(Request $request, $slug)
    {
        try {
            $category = Category::where('slug', $slug)->firstOrFail();
    
            $validator = Validator::make($request->all(), [
                'name' => 'required|string|max:255|unique:categories,name,' . $category->id,
                'color_ids' => 'nullable|array',
                'size_ids' => 'nullable|array',
                'variation_ids' => 'nullable|array',
            ]);
    
            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }
    
            $validatedData = $validator->validated();
    
            $category->update([
                'name' => $validatedData['name'],
                'color_ids' => $validatedData['color_ids'] ?? [],
                'size_ids' => $validatedData['size_ids'] ?? [],
                'variation_ids' => $validatedData['variation_ids'] ?? [],
            ]);
    
            return redirect()->route('admin.category.index')->with('success', 'Category successfully updated.');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
    

    public function delete(Request $request)
    {
        try {
            $category = Category::where('slug', $request->slug)->first();
            
            $category->delete();
            return redirect()->route('admin.category.index')->with('success', 'Category successfully deleted.');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
}
