<?php

namespace App\Http\Controllers\Admin\Color;



use App\Http\Controllers\Controller;
use App\Models\Color;
use App\Models\Category;
use Illuminate\Http\Request;

class ColorController extends Controller
{
    public function index()
    {
        $colors = Color::all();
        return view('admin.color.index', compact('colors'));
    }

    public function create()
    {
        $categories = Category::all();
        return view('admin.color.add', compact('categories'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:colors,name',
        ]);

        Color::create(['name' => $request->name]);

        return redirect()->route('admin.color.index')->with('success', 'Color added successfully.');
    }

    public function edit($slug)
    {
        $color = Color::where('slug', $slug)->firstOrFail();
        return view('admin.color.edit', compact('color'));
    }

    public function update(Request $request, $slug)
    {
        $color = Color::where('slug', $slug)->firstOrFail();

        $request->validate([
            'name' => 'required|string|max:255|unique:colors,name,' . $color->id,
        ]);

        $color->update(['name' => $request->name]);

        return redirect()->route('admin.color.index')->with('success', 'Color updated successfully.');
    }

    public function destroy(Request $request)
    {
        $color = Color::where('slug', $request->slug)->firstOrFail();
        $color->delete();

        return response()->json(['success' => true]);
    }
}

