<?php

namespace App\Http\Controllers\Admin\Commission;

use App\Http\Controllers\Controller;
use App\Models\Commission;
use App\Models\PageMetaTag;
use App\Models\WebPages;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use App\Models\Vendor;
use Exception;
use App\Models\Booking;

class CommissionController extends Controller
{
    public $file_path = 'admin.commission.';
  

 

    // public function index(Request $request)
    // {
    //     $year = $request->get('year', now()->year);
    
    //     $spos = Vendor::where('status', 'active')->get();
        
    //     $dashboardAnalytics = [
    //         'total_revenue' => 0,
    //         'total_commission' => 0,
    //         'commission_fulltimer' => 0,
    //         'commission_sidebusiness' => 0,
    //     ];
    
    //     foreach ($spos as $vendor) {
    
    //         $bookingsByMonth = Booking::where('vendor_id', $vendor->id)
    //             ->whereIn('status', ['confirmed', 'completed', 'cancelled'])
    //             ->whereYear('created_at', $year)
    //             ->get()
    //             ->groupBy(function ($b) {
    //                 return \Carbon\Carbon::parse($b->created_at)->format('m'); 
    //             });

            
    
    //         $annualRevenue = 0;
    //         $annualCommission = 0;
    //         $monthlyData = []; 

    //         foreach ($bookingsByMonth as $month => $bookings) {
    //             $monthlyRevenue = $bookings->sum(function ($b) {
    //                 return ($b->total ?? 0) - ($b->refund_amount ?? 0);
    //             });

    //             $annualRevenue += $monthlyRevenue;

    //             [$commissionRate, $shopFeeRate] = $this->getCommissionRatesForAmount($vendor, $annualRevenue);


    //             $monthlyCommission = round(($monthlyRevenue * $commissionRate) / 100, 2);
    //             $monthlyShopFee = round($shopFeeRate, 2);
    
    //             $totalFee = $monthlyCommission + $monthlyShopFee;
    //             $totalFeeNet = round($totalFee / 1.19, 2);
    //             $totalFeeTax = round($totalFee - $totalFeeNet, 2);
    
    //             $annualCommission += $monthlyCommission;
    
    //             $monthlyData[$month] = [
    //                 'revenue' => $monthlyRevenue,
    //                 'commission_rate' => $commissionRate,
    //                 'commission' => $monthlyCommission,
    //                 'shop_fee' => $monthlyShopFee,
    //                 'total_fee' => $totalFee,
    //                 'total_fee_net' => $totalFeeNet,
    //                 'total_fee_tax' => $totalFeeTax,
    //             ];
    //         }
    //         // Final annual totals
    //         $vendor->annual_revenue = round($annualRevenue, 2);
    //         $vendor->annual_commission = round($annualCommission, 2);
    //         $vendor->monthly_data = $monthlyData;


    //         $dashboardAnalytics['total_revenue'] += $vendor->annual_revenue;
    //         $dashboardAnalytics['total_commission'] += $vendor->annual_commission;

    //          if ($vendor->business_model === 'Fulltimer') {
    //             $dashboardAnalytics['commission_fulltimer'] += $vendor->annual_commission;
    //         } elseif ($vendor->business_model === 'Side Business') {
    //             $dashboardAnalytics['commission_sidebusiness'] += $vendor->annual_commission;
    //         }
    //     }
    
    //     return view($this->file_path . 'index', compact('spos', 'year', 'dashboardAnalytics'));
    // }
    
    public function index(Request $request)
{
    $year = $request->get('year', now()->year);

    $spos = Vendor::where('status', 'active')->get();

    $dashboardAnalytics = [
        'total_revenue' => 0,
        'total_commission' => 0,
        'commission_fulltimer' => 0,
        'commission_sidebusiness' => 0,
    ];

    foreach ($spos as $vendor) {

        // Get all bookings for this vendor up to the selected year
        $allBookings = Booking::where('vendor_id', $vendor->id)
            ->whereIn('status', ['confirmed', 'completed', 'cancelled'])
            ->get()
            ->sortBy('created_at');

        $monthlyData = [];
        $annualRevenue = 0;
        $annualCommission = 0;

        $firstBooking = Booking::where('vendor_id', $vendor->id)
            ->whereIn('status', ['confirmed', 'completed', 'cancelled'])
            ->orderBy('created_at', 'asc')
            ->first();
            
        $vendorStartYear = $firstBooking ? $firstBooking->created_at->year : $year;



        for ($month = 1; $month <= 12; $month++) {
            $monthName = date('F', mktime(0, 0, 0, $month, 10));

            // Monthly bookings for the selected year
            $monthBookings = $allBookings->filter(function ($b) use ($year, $month) {
                return $b->created_at->year == $year && $b->created_at->month == $month;
            });

            $monthlyRevenue = $monthBookings->sum(function ($b) {
                return ($b->total ?? 0) - ($b->refund_amount ?? 0);
            });

            // --- Cumulative / Rolling Revenue Calculation ---
            if ($year == $vendorStartYear) {
                // First year → cumulative from start
                $cumulativeRevenue = $allBookings->filter(function ($b) use ($year, $month) {
                    return ($b->created_at->year == $year && $b->created_at->month <= $month);
                })->sum(function ($b) {
                    return ($b->total ?? 0) - ($b->refund_amount ?? 0);
                });
            } else {
                // Subsequent years → last 12 months
                $startDate = \Carbon\Carbon::createFromDate($year, $month, 1)->subMonths(11)->startOfMonth();
                $endDate = \Carbon\Carbon::createFromDate($year, $month, 1)->endOfMonth();

                $cumulativeRevenue = $allBookings->filter(function ($b) use ($startDate, $endDate) {
                    return $b->created_at >= $startDate && $b->created_at <= $endDate;
                })->sum(function ($b) {
                    return ($b->total ?? 0) - ($b->refund_amount ?? 0);
                });
            }

            [$commissionRate, $shopFeeRate] = $this->getCommissionRatesForAmount($vendor, $cumulativeRevenue);

            $monthlyCommission = round(($monthlyRevenue * $commissionRate) / 100, 2);
            $monthlyShopFee = round($shopFeeRate, 2);

            $totalFee = $monthlyCommission + $monthlyShopFee;
            $totalFeeNet = round($totalFee / 1.19, 2);
            $totalFeeTax = round($totalFee - $totalFeeNet, 2);

            $annualRevenue += $monthlyRevenue;
            $annualCommission += $monthlyCommission;

            $monthlyData[$monthName] = [
                'revenue' => $monthlyRevenue,
                'cumulative_revenue' => $cumulativeRevenue,
                'commission_rate' => $commissionRate,
                'commission' => $monthlyCommission,
                'shop_fee' => $monthlyShopFee,
                'total_fee' => $totalFee,
                'total_fee_net' => $totalFeeNet,
                'total_fee_tax' => $totalFeeTax,
            ];
        }

        // Final annual totals
        $vendor->annual_revenue = round($annualRevenue, 2);
        $vendor->annual_commission = round($annualCommission, 2);
        $vendor->monthly_data = $monthlyData;

        $dashboardAnalytics['total_revenue'] += $vendor->annual_revenue;
        $dashboardAnalytics['total_commission'] += $vendor->annual_commission;

        if ($vendor->business_model === 'Fulltimer') {
            $dashboardAnalytics['commission_fulltimer'] += $vendor->annual_commission;
        } elseif ($vendor->business_model === 'Side Business') {
            $dashboardAnalytics['commission_sidebusiness'] += $vendor->annual_commission;
        }
    }

    return view($this->file_path . 'index', compact('spos', 'year', 'dashboardAnalytics'));
}

    


    public function saveCommission(Request $request, Vendor $vendor)
    {
        $validator = Validator::make($request->all(), [
            'from_amount.*' => 'required|numeric|min:0',
            'to_amount.*' => 'required|numeric|min:0',
            'commission_percent.*' => 'required|numeric|min:0|max:100',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'success' => false,
                'errors' => $validator->errors()
            ]);
        }

        $fromAmounts = $request->input('from_amount', []);
        $toAmounts = $request->input('to_amount', []);
        $commissions = $request->input('commission_percent', []);
        $shopFees = $request->input('shop_fee', []);
    
        $commissionData = [];

        foreach ($fromAmounts as $i => $from) {
            $to = $toAmounts[$i] ?? '';
            $commission = $commissions[$i] ?? 0;
            $shop_fee = $shopFees[$i] ?? 0;
            $rangeKey = $to ? "{$from}-{$to}" : "{$from}-";
    
            $commissionData[$rangeKey] = [
                'commission' => (float) $commission,
                'shop_fee' => (float) $shop_fee,
            ];
        }

        $vendor->commission_rate = $commissionData;
        $vendor->save();


        return response()->json([
            'success' => true,
            'message' => 'Commission rates saved successfully!',
            'data' => $vendor->commission_rate,
        ]);
    }

    // public function detail(Request $request, Vendor $vendor)
    // {
    //     $year = $request->get('year', now()->year);
    
    //     $bookings = Booking::where('vendor_id', $vendor->id)
    //         ->whereIn('status', ['confirmed', 'completed', 'cancelled'])
    //         ->whereYear('created_at', $year)
    //         ->get();
    
    //     $monthlyData = [];
    
    //     $payoutDates = $vendor->payout_dates ?? [];
    //     $yearPayouts = $payoutDates[$year] ?? [];
    
    //     $cumulativeRevenue = 0; 
    
    //     for ($month = 1; $month <= 12; $month++) {
    //         $monthName = date('F', mktime(0, 0, 0, $month, 10));
    
    //         $monthBookings = $bookings->filter(function ($b) use ($month) {
    //             return $b->created_at->month == $month;
    //         });
    
    //         $monthlyRevenue = $monthBookings->sum(function ($b) {
    //             return ($b->total ?? 0) - ($b->refund_amount ?? 0);
    //         });
    
    //         $cumulativeRevenue += $monthlyRevenue;
    
    //         [$commissionRate, $shopFeeRate] = $this->getCommissionRatesForAmount($vendor, $cumulativeRevenue);
    
    //         $monthlyCommission = round(($monthlyRevenue * $commissionRate) / 100, 2);
    //         $monthlyShopFee = round($shopFeeRate, 2);
    
    //         $totalFee = $monthlyCommission + $monthlyShopFee;
    //         $totalFeeNetAmount = round($totalFee / 1.19, 2);
    //         $totalFeeTaxAmount = round($totalFee - $totalFeeNetAmount, 2);
    //         $payout = round($monthlyRevenue - $totalFee, 2);
    
    //         $monthTotalBookings = Booking::where('vendor_id', $vendor->id)
    //             ->whereYear('created_at', $year)
    //             ->whereMonth('created_at', $month)
    //             ->count();
    
    //         $monthCancelledBookings = Booking::where('vendor_id', $vendor->id)
    //             ->where('status', 'cancelled')
    //             ->whereYear('created_at', $year)
    //             ->whereMonth('created_at', $month)
    //             ->count();
    
    //         $monthCancellationRate = $monthTotalBookings > 0
    //             ? round(($monthCancelledBookings / $monthTotalBookings) * 100, 2)
    //             : 0;
    
    //         $payoutDate = $yearPayouts[$monthName] ?? null;
    
    //         $monthlyData[$monthName] = [
    //             'total_revenue' => $monthlyRevenue,
    //             'cumulative_revenue' => $cumulativeRevenue, 
    //             'commission_rate' => $commissionRate,
    //             'commission' => $monthlyCommission,
    //             'shop_fee' => $monthlyShopFee,
    //             'totalFee' => $totalFee,
    //             'totalFeeNetAmount' => $totalFeeNetAmount,
    //             'totalFeeTaxAmount' => $totalFeeTaxAmount,
    //             'payout' => $payout,
    //             'cancellation_rate' => $monthCancellationRate,
    //             'payout_date' => $payoutDate,
    //         ];
    //     }
    
    //     $totalBookings = Booking::where('vendor_id', $vendor->id)
    //         ->whereYear('created_at', $year)
    //         ->count();
    
    //     $cancelledBookings = Booking::where('vendor_id', $vendor->id)
    //         ->where('status', 'cancelled')
    //         ->whereYear('created_at', $year)
    //         ->count();
    
    //     $cancellationRate = $totalBookings > 0
    //         ? round(($cancelledBookings / $totalBookings) * 100, 2)
    //         : 0;
    
    //     return view($this->file_path . 'detail', compact(
    //         'vendor',
    //         'monthlyData',
    //         'year',
    //         'cancellationRate'
    //     ));
    // }

    public function detail(Request $request, Vendor $vendor)
{
    $year = $request->get('year', now()->year);

    // Get all bookings of this vendor including previous year for rolling calculation
    $startDate = \Carbon\Carbon::createFromDate($year - 1, 1, 1);
    $endDate = \Carbon\Carbon::createFromDate($year, 12, 31);
    $bookings = Booking::where('vendor_id', $vendor->id)
        ->whereIn('status', ['confirmed', 'completed', 'cancelled'])
        ->whereBetween('created_at', [$startDate, $endDate])
        ->get();

    $monthlyData = [];
    $payoutDates = $vendor->payout_dates ?? [];
    $yearPayouts = $payoutDates[$year] ?? [];

    // Determine the starting year of the SPO
    $firstBooking = Booking::where('vendor_id', $vendor->id)
        ->orderBy('created_at', 'asc')
        ->first();
    $startYear = $firstBooking ? $firstBooking->created_at->year : $year;

    for ($month = 1; $month <= 12; $month++) {
        $monthName = date('F', mktime(0, 0, 0, $month, 10));

        // Filter bookings for the current month
        $monthBookings = $bookings->filter(function ($b) use ($year, $month) {
            return $b->created_at->year == $year && $b->created_at->month == $month;
        });

        $monthlyRevenue = $monthBookings->sum(function ($b) {
            return ($b->total ?? 0) - ($b->refund_amount ?? 0);
        });

        // Determine revenue basis for commission & shop fee
        if ($year == $startYear) {
            // First year: cumulative within that year only
            $cumulativeRevenue = $bookings->filter(function ($b) use ($year, $month) {
                return $b->created_at->year == $year && $b->created_at->month <= $month;
            })->sum(function ($b) {
                return ($b->total ?? 0) - ($b->refund_amount ?? 0);
            });
        } else {
            // Subsequent years: rolling 12 months ending at current month
            $end = \Carbon\Carbon::createFromDate($year, $month, 1)->endOfMonth();
            $start = $end->copy()->subMonths(11)->startOfMonth();

            $cumulativeRevenue = $bookings->filter(function ($b) use ($start, $end) {
                return $b->created_at >= $start && $b->created_at <= $end;
            })->sum(function ($b) {
                return ($b->total ?? 0) - ($b->refund_amount ?? 0);
            });
        }

        // Get commission and shop fee based on cumulative revenue
        [$commissionRate, $shopFeeRate] = $this->getCommissionRatesForAmount($vendor, $cumulativeRevenue);

        $monthlyCommission = round(($monthlyRevenue * $commissionRate) / 100, 2);
        $monthlyShopFee = round($shopFeeRate, 2);

        $totalFee = $monthlyCommission + $monthlyShopFee;
        $totalFeeNetAmount = round($totalFee / 1.19, 2);
        $totalFeeTaxAmount = round($totalFee - $totalFeeNetAmount, 2);
        $payout = round($monthlyRevenue - $totalFee, 2);

        $monthTotalBookings = Booking::where('vendor_id', $vendor->id)
            ->whereYear('created_at', $year)
            ->whereMonth('created_at', $month)
            ->count();

        $monthCancelledBookings = Booking::where('vendor_id', $vendor->id)
            ->where('status', 'cancelled')
            ->whereYear('created_at', $year)
            ->whereMonth('created_at', $month)
            ->count();

        $monthCancellationRate = $monthTotalBookings > 0
            ? round(($monthCancelledBookings / $monthTotalBookings) * 100, 2)
            : 0;

        $payoutDate = $yearPayouts[$monthName] ?? null;

        $monthlyData[$monthName] = [
            'total_revenue' => $monthlyRevenue,
            'cumulative_revenue' => $cumulativeRevenue,
            'commission_rate' => $commissionRate,
            'commission' => $monthlyCommission,
            'shop_fee' => $monthlyShopFee,
            'totalFee' => $totalFee,
            'totalFeeNetAmount' => $totalFeeNetAmount,
            'totalFeeTaxAmount' => $totalFeeTaxAmount,
            'payout' => $payout,
            'cancellation_rate' => $monthCancellationRate,
            'payout_date' => $payoutDate,
        ];
    }

    $totalBookings = Booking::where('vendor_id', $vendor->id)
        ->whereYear('created_at', $year)
        ->count();

    $cancelledBookings = Booking::where('vendor_id', $vendor->id)
        ->where('status', 'cancelled')
        ->whereYear('created_at', $year)
        ->count();

    $cancellationRate = $totalBookings > 0
        ? round(($cancelledBookings / $totalBookings) * 100, 2)
        : 0;

    return view($this->file_path . 'detail', compact(
        'vendor',
        'monthlyData',
        'year',
        'cancellationRate'
    ));
}

    
    private function getCommissionRatesForAmount($vendor, $amount)
    {
        $commissionRate = 0;
        $shopFeeRate = 0;

        if (!empty($vendor->commission_rate) && is_array($vendor->commission_rate)) {
            foreach ($vendor->commission_rate as $range => $data) {
                $parts = explode('-', $range);
                $from = (float) ($parts[0] ?? 0);
                $to = isset($parts[1]) && $parts[1] !== '' ? (float) $parts[1] : null;

                if ($to === null && $amount >= $from) {
                    $commissionRate = $data['commission'] ?? 0;
                    $shopFeeRate = $data['shop_fee'] ?? 0;
                    break;
                }

                if ($amount >= $from && $amount <= $to) {
                    $commissionRate = $data['commission'] ?? 0;
                    $shopFeeRate = $data['shop_fee'] ?? 0;
                    break;
                }
            }
        }
        return [$commissionRate, $shopFeeRate];
    }

    public function updatePayoutStatus(int $id , Request $request){

        $vendor = Vendor::where('id',$id)->update(['stop_payout' => $request['status']]);
        return response()->json(['success' => true]);

    }

    public function updatePayoutDate(Request $request, Vendor $vendor) {
        $request->validate([
            'month' => 'required|string',        // "January"
            'year' => 'required|digits:4',       // "2025"
            'payout_date' => 'required|date',    // "2025-01-31"
        ]);
    
        $payoutDates = $vendor->payout_dates ?? []; // get existing JSON
    
        if(!isset($payoutDates[$request->year])) {
            $payoutDates[$request->year] = [];
        }
    
        // Update month payout date
        $payoutDates[$request->year][$request->month] = $request->payout_date;
    
        $vendor->payout_dates = $payoutDates; // save back as JSON
        $vendor->save();
    
        return response()->json(['success' => true]);
    }

    

    
}
