<?php

namespace App\Http\Controllers\Admin\ContentManagement;

use App\Http\Controllers\Controller;
use App\Models\ContentManagement;
use App\Models\PageMetaTag;
use App\Models\WebPages;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Str;
use Exception;


class ContentManagementController extends Controller
{
    public $file_path = 'admin.page-setting.';
    public $ignors = [
        '_token'
    ];

    public function index()
    {
        
        $contents = ContentManagement::orderBy('id', 'desc')->get();
        $data = WebPages::orderBy('name', 'asc')->get();
        return view('admin.content_management.index', compact('contents', 'data'));
    }

    public function createContent(Request $request)
    {

        return view('admin.content_management.create');
    }

    public function storeContent(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'description' => 'required|string',
            'meta_title' => 'nullable|string|max:255',
            'meta_keyword' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string|max:255',
        ]);


        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }


        ContentManagement::create([
            'title' => $request->title,
            'slug' => $request->slug,
            'description' => $request->description,
            'meta_title' => $request->meta_title,
            'meta_keyword' => $request->meta_keyword,
            'meta_description' => $request->meta_description,
        ]);


        return redirect()->route('admin.content.index')->with('success', 'Content created successfully.');
    }

    public function editContent(Request $request, ContentManagement $content)
    {
        
        return view('admin.content_management.edit', compact('content'));
    }

    public function updateContent(Request $request, ContentManagement $content)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'description' => 'required|string',
            'meta_title' => 'nullable|string|max:255',
            'meta_keyword' => 'nullable|string|max:255',
            'meta_description' => 'nullable|string|max:255',
        ]);


        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        

        $content->title = $request->title;
        $content->description = $request->description;
        $content->slug = $request->slug;
        $content->meta_title = $request->meta_title;
        $content->meta_keyword = $request->meta_keyword;
        $content->meta_description = $request->meta_description;
        $content->save();
  
     
               
                  
        updateMeta('page_title', $request->title, $request->slug, $request);

        updateMeta('is_header', $request->is_header ?? 0, $request->slug, $request);
    
        updateMeta('is_footer', $request->is_footer ?? 0, $request->slug, $request);
                
                
            
        
        
        return redirect()->route('admin.content.index')->with('success', 'Content updated successfully.');;
    }

    public function edit(Request $request, $page_type)
    {
        $section = $request->query('section');
    
        if ($section === 'testimonial' && $page_type=='home') {
            return view($this->file_path . 'testimonial', ['page_type' => $page_type]);
        }
        return view($this->file_path . $page_type, ['page_type' => $page_type]);
    }

    // Update data function
    //     public function update(Request $request, $page_type){
    //         dd($request->all());
    //         foreach ($request->all() as $key => $value) {
    //           	if(!in_array($key, $this->ignors)):
    //         	    updateMeta($key, $value, $page_type, $request);
    //            	endif;
    //         }
    //         return redirect()->route('admin.content.index')->with('success', 'Content updated successfully.');
    //     }    

    public function update(Request $request, $page_type){
        try {
            // dd($request->all());
            foreach ($request->all() as $key => $value) {
                if (!in_array($key, $this->ignors)) {
                    $webPage = WebPages::where('slug',$page_type)->first();
                    if($webPage){
                      $chk = PageMetaTag::where(['key'=> 'page_title', 'type'=> $page_type])->first();
                     if($chk){
                      $webPage->name = $chk->key_value;
                      $webPage->save();
                     }
                    }
                if(isset($request->remove_video1) && !empty($request->remove_video1)){
                  
                    updateMeta('video1', "", $page_type, $request);
                }
                if(isset($request->remove_video2) && !empty($request->remove_video2)){
                  
                    updateMeta('video2', "", $page_type, $request);
                }
                if(isset($request->remove_video3) && !empty($request->remove_video3)){
                  
                    updateMeta('video3', "", $page_type, $request);
                }
                if(!isset($request->is_header)){
                  
                    updateMeta('is_header', 0, $page_type, $request);
                }
                if(!isset($request->is_footer)){
                    updateMeta('is_footer', 0, $page_type, $request);
                }
                    updateMeta($key, $value, $page_type, $request);
                }
                
            }
            return redirect()->route('admin.content.index')->with('success', 'Content updated successfully.');
        } catch (\Exception $e) {
            dd($e->getMessage());
            return redirect()->route('admin.content.index')->with('error', 'An error occurred: ' . $e->getMessage());
        }
    }
}
