<?php

namespace App\Http\Controllers\Admin\Faq;

use App\Http\Controllers\Controller;
use App\Models\Faq;
use Illuminate\Http\Request;
use Validator;

class FaqController extends Controller
{
    public function index(){
        $faqs = Faq::orderBy('id','desc')->get();
        return view('admin.faq_management.index', compact('faqs'));
    }

    public function createFaq(){
        
        return view('admin.faq_management.create');
    }
    public function storeFaq(Request $request){
   
        $validator = Validator::make($request->all(), [
           'question' => 'required|string|max:255',
           'answer' => 'required|string|max:255',
       ]);
   
      
       if ($validator->fails()) {
           return redirect()->back()->withErrors($validator)->withInput();
       }
   
    
       Faq::create([
           'question' => $request->question,
           'answer' => $request->answer,
           'status' => $request->status,
       ]);
   
      
       return redirect()->route('admin.faq.index')->with('success', 'FAQ created successfully.');
   
       }
       public function editFaq(Request $request, Faq $faq){
       
        return view('admin.faq_management.edit',compact('faq'));
    }
    public function updateFaq(Request $request, Faq $faq){

        $validator = Validator::make($request->all(), [
            'question' => 'required|string|max:255',
            'answer' => 'required|string|max:255',
        ]);
    
       
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $faq->question = $request->question;
        $faq->answer = $request->answer;
        $faq->save();
        return redirect()->route('admin.faq.index')->with('success', 'Faq updated successfully.');
    }
}
