<?php

namespace App\Http\Controllers\Admin\PageMetaTag;

use App\Http\Controllers\Controller;
use App\Models\PageMetaTag;
use App\Models\WebPage;
use Illuminate\Http\Request;

class CmsPageController extends Controller
{
    public $ignors = [
	    '_token'
	];

    public function index()
    {
        $pages = WebPage::orderBy('id', 'desc')->get();
        return view('admin.page_meta_tags.index', compact('pages'));
    }
    public $file_path = 'admin.page_settings.';

    // Listing page function
    public function list()
    {
        $cms_page_data = PageMetaTag::orderBy('created_at', 'asc')->paginate(10);
        return view($this->file_path . 'index', ["cms_page_data" => $cms_page_data]);
    }

    // Create new function
    public function create()
    {
        return view('admin.page_meta_tags.create-page');
    }
    public function storePage(Request $request)
    {
        $request->validate([
            'name' => 'required',
        ]);
        $data = new WebPage();
        $data->name = trim($request->name);
        $data->slug = $request->slug;
        $data->save();

        return redirect()->route('admin.page.index')->with('success', ($data->slug) . ' Page Created Successfully.');

    }
    public function update(Request $request, $page_type){
        foreach ($request->all() as $key => $value) {
          	if(!in_array($key, $this->ignors)):
        	    updateMeta($key, $value, $page_type, $request);
           	endif;
        }
        return redirect()->back()->with('success', SlugToText($page_type).' is updated successfully.');
    }

    // Edit view function
    public function edit($slug)
    {
        return view($this->file_path . $slug, ["page_type" => $slug]);

    }
    public function generalSetting(Request $request)
    {
        return view($this->file_path . 'general-settings', ["page_type" => 'general-settings']);

    }

   

  
}
