<?php

namespace App\Http\Controllers\Admin\Pricing;

use App\Http\Controllers\Controller;
use App\Models\ProductPrice;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use PDF;
use League\Csv\Reader;
class PriceController extends Controller

{

    public $file_path = 'admin.pricing.';

    public function index(Request $request)
    {
        $search ="";
        try {
            if (isset($request->search_cat_prod) && !empty($request->search_cat_prod)) {
                $search = $request->search_cat_prod;
                
                $productPrices = ProductPrice::query()
                    ->where(function ($query) use ($search) {
                        $query->where('category_name', 'like', "%{$search}%")
                              ->orWhere('product_name', 'like', "%{$search}%");
                    })
                    ->orderBy('id', 'desc')
                    ->get();
            } else {
                // If no search, get all ordered
                $productPrices = ProductPrice::orderBy('id', 'desc')->get();
            }
            //    dd($productPrices);
            return view($this->file_path . 'index', compact('productPrices','search'));
        } catch (Exception $e) {

            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function show($id)
    {
        try {
            $productPrice = ProductPrice::where('id', $id)->first();
            return view($this->file_path . 'view', compact('productPrice'));
        } catch (Exception $e) {

            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function add(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'name' => 'required|string|max:255|unique:categories,name',
            ]);

            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $validatedData = $validator->validated();
            $validatedData['name'] = strtolower($validatedData['name']);

            // $category = Category::create($validatedData);

            return redirect()->route('admin.category.index')->with('success', 'Category successfully added.');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function edit($id)
    {
        // $category = Category::where('slug', $slug)->first();
        $productPrice = ProductPrice::where('id', $id)->first();
        return view($this->file_path . 'edit', compact('productPrice'));
    }

    public function update(Request $request, $slug)
    {
        dd('working');

        // try {
        //     $category = Category::where('slug', $slug)->first();

        //     if (!$category) {
        //         return redirect()->back()->with('error', 'Category not found.');
        //     }

        //     $validator = Validator::make($request->all(), [
        //         'name' => 'required|string|max:255|unique:categories,name,' . $category->id,
        //     ]);

        //     if ($validator->fails()) {
        //         return redirect()->back()->withErrors($validator)->withInput();
        //     }

        //     $validatedData = $validator->validated();
        //     $validatedData['name'] = strtolower($validatedData['name']);

        //     $category->update($validatedData);

        //     return redirect()->route('admin.category.index')->with('success', 'Category successfully updated.');
        // } catch (Exception $e) {
        //     return redirect()->back()->with('error', $e->getMessage());
        // }
    }

    public function delete(Request $request)
    {
        dd('working');
        // try {
        //     $category = Category::where('slug', $request->slug)->first();
        //     $category->delete();
        //     return redirect()->route('admin.category.index')->with('success', 'Category successfully deleted.');
        // } catch (Exception $e) {
        //     return redirect()->back()->with('error', $e->getMessage());
        // }
    }

    public function uploadPriceCsv(Request $request)
    {

        // Validate the uploaded file (CSV or Excel only)
        $request->validate([
            'file' => 'required|mimes:csv,xlsx|max:2048', // Max file size 2MB
        ]);
        // dd($request->all());
        // Get the file
        $file = $request->file('file');

        $fileName = 'product_prices.' . $file->getClientOriginalExtension(); // e.g., product_prices.csv
        $directory = '/public/csv_files'; // storage/app/csv_files
        $path = $file->storeAs($directory, $fileName); // This will replace the file if it already exists

        // Full path for processing
        $fullPath = storage_path('app/public/' . $path);

        // Handle file based on extension
        $extension = $file->getClientOriginalExtension();

        if ($extension == 'csv') {
            $this->getAllProductPrices($file);
        } elseif ($extension == 'xlsx') {
            // Process Excel file

        }

        // return back()->with('success', 'File has been uploaded and processed!');
    }

    public function getAllProductPrices($filePath)
    {

        $data = [];

        $handle = fopen($filePath, 'r');
        if ($handle !== FALSE) {
            $index = 0;

            while (($row = fgetcsv($handle)) !== FALSE) {

                $columns = array_slice($row, 0, length: 11);

                $data[] = $columns;


                $index++;
            }


            fclose($handle);
        }
        $transformed = [];
        $numOfProducts = count($data[0]);
        // Loop through each product and combine corresponding values
        for ($i = 0; $i < $numOfProducts; $i++) {
            $product = $data[0][$i];
            $transformed[$product] = [];

            // Loop through the rest of the arrays (value sets)
            for ($j = 1; $j < count($data); $j++) {
                $transformed[$product][] = $data[$j][$i];
            }
        }



        //    dd($transformed);
        // $validKeys = ['Roof Box', 'Roof Bike Carrier', 'Clutch Bike Carrier', 'Rear Box', 'Roof Rack' , 'Roof Rack added to Roof Box/Roof Bike Rack','Traverse.
        // ','Foot','Footkit'];

        $validKeys = ['Roof Box', 'Roof Bike Carrier', 'Clutch Bike Carrier', 'Rear Box', 'Roof Rack' , 'Roof Rack added to Roof Box/Roof Bike Rack','Traverse.
        ','Foot','Footkit' , 'Dachbox', 'Dachfahrradträger' , 'Kupplungsfahrradträger' , 'Heckbox','Dachträger','Dachträger ergänzt zu Dachbox/ Dachfahrradträger','Traverse' , 'Fuß','Fußkit'];

        foreach ($transformed as $key => $value) {
            if (in_array($key, $validKeys)) {
                $this->storeProduct($key, $value);
            }
        }
        return response()->json(['message' => 'Product saved successfully!'], 200);
    }

    public function storeProduct($product_name, $prices)
    {

        $existedProduct = ProductPrice::where('product_name', $product_name)->first();

        if ($existedProduct) {
            $existedProduct->product_name = $product_name;
            $existedProduct->category_name = $product_name;
            $existedProduct->price = $prices;
            $existedProduct->save();
        } else {
            $product = new ProductPrice();
            $product->product_name = $product_name;
            $product->category_name = $product_name;
            $product->price = $prices;
            $product->save();
        }
    }

    public function updatePrice(Request $request)
    {
        // dd($request->all());
        $prices = $request->week;
        $product_id = $request->id;
        $this->updateCsvPrices($prices, $request->product_name);

        $product = ProductPrice::where('id', $product_id)->first();
        if ($product) {
            $product->product_name = $request->product_name;
            $product->category_name = $request->category_name;
            $product->price = $prices;
            $product->save();
            return redirect()->route('admin.price.index')->with('success', 'Price successfully updated.');
        }

        return redirect()->back()->with('error', 'Product not found.');

    }

    public function updateCsvPrices($prices, $product_name)
    {
       

        $filePath = storage_path('app/public/csv_files/product_prices.csv'); // Adjust path if needed

        $data = [];

        $handle = fopen($filePath, 'r');
        if ($handle !== FALSE) {
            $index = 0;

            while (($row = fgetcsv($handle)) !== FALSE) {




                $columns = array_slice($row, 0, 11);

                $data[] = $columns;


                $index++;
            }


            fclose($handle);
        }
        $transformed = [];
        // dd($data);
        $numOfProducts = count($data[0]);

        // Loop through each product and combine corresponding values
        for ($i = 0; $i < $numOfProducts; $i++) {
            $product = $data[0][$i];
            $transformed[$product] = [];

            // Loop through the rest of the arrays (value sets)
            for ($j = 1; $j < count($data); $j++) {
                $transformed[$product][] = $data[$j][$i];
            }
        }
        // dd($transformed);
        $priceUpdates = [
            $product_name => $prices,
        ];
        
        // Step 4: Update prices in transformed data
        foreach ($priceUpdates as $product => $newPrices) {
            // dd($newPrices);
            if (isset($transformed[$product])) {
                foreach ($newPrices as $index => $newPrice) {
                    // dd($newPrice);
                    if (isset($transformed[$product][$index])) {
                        // dd($transformed[$product][$index]);
                        $transformed[$product][$index] = $newPrice;
                    }
                }
            }
        }
        
        // Step 5: Transpose back to row-wise format
        $updatedData = [];
        
        // Add headers
        $updatedData[] = array_keys($transformed);
        // dd($updatedData);
        // Add values row by row
        for ($i = 0; $i < count(current($transformed)); $i++) {
            $row = [];
            foreach ($transformed as $values) {
                $row[] = $values[$i] ?? '';
            }
            $updatedData[] = $row;
        }
        // dd($updatedData);
        // Step 6: Write back to CSV
        $handle = fopen($filePath, 'w');
        if ($handle !== FALSE) {
            foreach ($updatedData as $row) {
                // dd($row);
                fputcsv($handle, $row);
            }
            fclose($handle);
        }
        
    }

    public function downloadPricePdf()
    {
        // Load CSV from storage
        $path = storage_path('app/public/csv_files/product_prices.csv');
        $csv = Reader::createFromPath($path, 'r');
        $csv->setHeaderOffset(0);

        $headers = $csv->getHeader();
        $rows = iterator_to_array($csv->getRecords());

        // Convert associative array to indexed array for rows
        $cleanedRows = array_map(fn($row) => array_values($row), $rows);

        $pdf = Pdf::loadView('admin.pricing.pdf', [
            'headers' => $headers,
            'rows' => $cleanedRows
        ])->setPaper('a4', 'landscape');

        return $pdf->download('product_prices.pdf');
    }
}
