<?php

namespace App\Http\Controllers\Admin\ProductBrand;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ProductBrand;
use Exception;
use Illuminate\Support\Facades\Validator;

class ProductBrandController extends Controller
{
    public $file_path = 'admin.product-brand.';

    public function getAll()
    {
        try {
            $brand = ProductBrand::all();
            return view($this->file_path . 'index', compact('brand'));
        } catch (Exception $e) {
            dd($e->getMessage());
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function addView()
    {
        try {
            return view($this->file_path . 'add');
        } catch (Exception $e) {
            dd($e->getMessage());
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function add(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                'name' => 'required|string|max:255|unique:product_brands,name',
            ]);
            

            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $validatedData = $validator->validated();
            $validatedData['name'] = ($validatedData['name']);

            $category = ProductBrand::create($validatedData);

            return redirect()->route('admin.category.index')->with('success', 'Brand successfully added.');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function edit($slug)
    {
        $brand = ProductBrand::where('slug', $slug)->first();
        return view($this->file_path . 'edit', compact('brand'));
    }

    public function update(Request $request, $slug)
    {
        try {
            $brand = ProductBrand::where('slug', $slug)->first();

            if (!$brand) {
                return redirect()->back()->with('error', 'Brand not found.');
            }

            $validator = Validator::make($request->all(), [
                'name' => 'required|string|max:255|unique:product_brands,name,' . $brand->id,
            ]);

            if ($validator->fails()) {
                return redirect()->back()->withErrors($validator)->withInput();
            }

            $validatedData = $validator->validated();
            $validatedData['name'] = ($validatedData['name']);

            $brand->update($validatedData);

            return redirect()->route('admin.category.index')->with('success', 'Brand successfully updated.');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }

    public function delete(Request $request)
    {
        try {
           
            $category = ProductBrand::where('slug', $request->slug)->first();
        
            $category->delete();
            return redirect()->route('admin.brand.index')->with('success', 'Brand successfully deleted.');
        } catch (Exception $e) {
            return redirect()->back()->with('error', $e->getMessage());
        }
    }
}
