<?php

namespace App\Http\Controllers\Admin\Size;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Size;
use App\Models\Category;
use Exception;
use Illuminate\Database\Eloquent\ModelNotFoundException;

class SizeController extends Controller
{
    public $file_path = 'admin.size.';

    public function index()
    {
        try {
            $sizes = Size::all();
            return view($this->file_path . 'index', compact('sizes'));
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while fetching the sizes.');
        }
    }

    public function create()
    {
        try {
            $categories = Category::all();
            return view($this->file_path . 'add', compact('categories'));
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while fetching the categories.');
        }
    }

    public function store(Request $request)
    {
        try {
            $request->validate([
               
                'name' => 'required|unique:sizes,name',
               
            ]);

            Size::create([
               
                'name' => ($request->name),
                
            ]);
            return redirect()->route('admin.size.index')->with('success', 'Size Successfully Added.');
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while adding the size.');
        }
    }

    public function edit($id)
    {
        try {
            $size = Size::findOrFail($id);
          
            return view($this->file_path . 'edit', compact('size'));
        } catch (ModelNotFoundException $e) {
            return redirect()->route('admin.size.index')->with('error', 'Size not found.');
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while fetching the size.');
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $size = Size::where('id', $id)->first();

            if (!$size) {
                return redirect()->back()->with('error', 'Size not found.');
            }

            $request->validate([
              
                'name' => 'required|unique:sizes,name,' . $size->id,
               
            ]);

            $size->update([
               
                'name' => ($request->name),

            ]);

            return redirect()->route('admin.size.index')->with('success', 'Size Successfully Updated');
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while updating the size.');
        }
    }

    public function delete(Request $request)
    {
        try {
            $id = $request->id;
            $size = Size::findOrFail($id);
            $size->delete();
            return redirect()->route('admin.size.index')->with('success', 'Size Successfully Deleted');
        } catch (ModelNotFoundException $e) {
            return back()->with('error', 'Size not found.');
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while deleting the size.');
        }
    }
}
