<?php

namespace App\Http\Controllers\Admin\Variation;

use App\Http\Controllers\Controller;
use App\Models\Size;
use App\Models\Variation;
use Illuminate\Http\Request;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Exception;

class VariationController extends Controller
{
    public $file_path = 'admin.variation.';

    public function index()
    {
        try {
            $variation = Variation::all();
            return view($this->file_path . 'index', compact('variation'));
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while fetching the variations.');
        }
    }

    public function create()
    {
        try {
            $size = Size::all();
            return view($this->file_path . 'add', compact('size'));
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while fetching the sizes.');
        }
    }

    public function store(Request $request)
    {
        try {
            $request->validate([
                
                'name' => 'required|unique:variations,name',
            ]);

            Variation::create([
              
                'name' => ($request->name),
            ]);
            return redirect()->route('admin.variation.index')->with('success', 'Variation Successfully Added.');
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while adding the variation.');
        }
    }

    public function edit($id)
    {
        try {
            $variation = Variation::findOrFail($id);
            $size = Size::all();
            return view($this->file_path . 'edit', compact( 'variation'));
        } catch (ModelNotFoundException $e) {
            return redirect()->route('admin.variation.index')->with('error', 'Variation not found.');
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while fetching the variation.');
        }
    }

    public function update(Request $request, $id)
    {
        try {
            $variation = Variation::find($id);

            if (!$variation) {
                return redirect()->back()->with('error', 'Variation not found.');
            }

            $request->validate([
                
                'name' => 'required|unique:variations,name,' . $variation->id,
            ]);

            $variation->update([
               
                'name' => ($request->name), 
            ]);

            return redirect()->route('admin.variation.index')->with('success', 'Variation Successfully Updated');
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while updating the variation.');
        }
    }

    public function delete(Request $request)
    {
        try {
            $id = $request->id;
            $variation = Variation::findOrFail($id);
            $variation->delete();
            return redirect()->route('admin.variation.index')->with('success', 'Variation Successfully Deleted');
        } catch (ModelNotFoundException $e) {
            return back()->with('error', 'Variation not found.');
        } catch (Exception $e) {
            return back()->with('error', 'An error occurred while deleting the variation.');
        }
    }
}
