<?php

namespace App\Http\Controllers\Frontend\Appointment;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use App\Models\Booking;
use App\Models\BookingItem;
use App\Models\BookingUserDetail;
use App\Models\CartItem;
use Carbon\Carbon;
use App\Models\WorkingHours;
use App\Models\ActivityLog;
use App\Models\Vendor;
class AppointmentController extends Controller
{
    public $file_path = 'frontend.user.';


    public function index()
    {
        try {
            $user_id = Auth::id();
            
            $bookings = Booking::with(['items', 'userDetails','items.product.homePhoto'])
                ->where('user_id', $user_id)
                ->where('status', 'confirmed')
                ->orderBy('created_at', 'desc')
                ->get();
            
            $recentBookings = [];
            $pastBookings = [];


            $vendors = Vendor::get()->keyBy('id');
            $adminAddress = 'Esperantostr. 10, 70197 Stuttgart';

            // Loop through each booking and attach vendor address to each item
            foreach ($bookings as $booking) {
                foreach ($booking->items as $item) {
                    if ($item->vendor_id && isset($vendors[$item->vendor_id])) {
                        $vendor = $vendors[$item->vendor_id];
                        $item->vendor_address = trim("{$vendor->street} {$vendor->zip_code} {$vendor->city}");
                    } else {
                        $item->vendor_address = $adminAddress;
                    }
                }
            }
            
            foreach ($bookings as $booking) {
                $latestItem = $booking->items->sortByDesc(function ($item) {
                    return $item->new_dropoff_date ?? $item->dropoff_date;
                })->first();
            
                if ($latestItem) {
                    $dropoffDate = $latestItem->new_dropoff_date ?? $latestItem->dropoff_date;
                    $dropoffTime = $latestItem->dropoff_time ?? null;
            
                    // Parse date/datetime safely
                    $dropoffDateTime = Carbon::parse($dropoffDate);
            
                    // If it's just a date (no time part), add time
                    if ($dropoffTime && $dropoffDateTime->format('H:i:s') === '00:00:00') {
                        $dropoffDateTime->setTimeFromTimeString($dropoffTime);
                    }
            
                    $now = Carbon::now();
            
                    if ($dropoffDateTime->greaterThan($now)) {
                        $recentBookings[] = $booking;
                    } else {
                        $pastBookings[] = $booking;
                    }
                }
            }
            
            return view($this->file_path . 'appointment.index', [
                'recentBookings' => $recentBookings,
                'pastBookings' => $pastBookings
            ]);
            
        } catch (\Exception $e) {
            Log::error('Booking Error: ' . $e->getMessage());
            return redirect()->back()->with('error', 'Something went wrong! Please try again later.');
        }
    }

    // public function getTime(Request $request)
    // {
    //     $carbonDate = \Carbon\Carbon::parse($request->date);
    //     $container = $request->container;
    //     $date = $carbonDate->toDateString();
    //     $day = $carbonDate->format('l');
    
    //     $from = '09:00';
    //     $to = '17:00';
    
    //     $workingHour = WorkingHours::where('day', $day)->first();
    //     if ($workingHour) {
    //         $from = $workingHour->open_time;
    //         $to = $workingHour->close_time;
    //     }

    //     $from = \Carbon\Carbon::parse($from)->format('H:i'); 
    //     $to = \Carbon\Carbon::parse($to)->format('H:i');     

    //     $start = \Carbon\Carbon::createFromFormat('H:i', $from);
    //     $end = \Carbon\Carbon::createFromFormat('H:i', $to);

        

    
    //     $slots = [];
    //     $slotDuration = 15;
    //     $slotGap = 15;

    //     if($container == '#from-slots'){
    //         $bookedTimes = BookingItem::whereDate('pickup_date', $date)
    //         ->get()
    //         ->flatMap(function ($item) {
    //             return [$item->pickup_time, $item->dropoff_time];
    //         })
    //         ->filter()
    //         ->map(function ($time) {
    //             return \Carbon\Carbon::parse($time)->format('H:i');
    //         })
    //         ->unique()
    //         ->values();

      
    
    //     while ($start->copy()->addMinutes($slotDuration)->lte($end)) {
    //         $slotStart = $start->format('H:i');
            
    //         $slotEnd = $start->copy()->addMinutes($slotDuration)->format('H:i');

           
    //         $slotLabel = "$slotStart - $slotEnd";
         
    //         $slots[] = [
    //             'label' => $slotLabel,
    //             'disabled' => $bookedTimes->contains($slotStart),
    //         ];
            
    //         $start->addMinutes($slotGap);
    //     }
    //     }else{
    //         $bookedTimes = BookingItem::whereDate('dropoff_date', $date)
    //         ->get()
    //         ->flatMap(function ($item) {
    //             return [$item->pickup_time, $item->dropoff_time];
    //         })
    //         ->filter()
    //         ->map(function ($time) {
    //             return \Carbon\Carbon::parse($time)->format('H:i');
    //         })
    //         ->unique()
    //         ->values();

      
    
    //     while ($start->copy()->addMinutes($slotDuration)->lte($end)) {
    //         $slotStart = $start->format('H:i');
            
    //         $slotEnd = $start->copy()->addMinutes($slotDuration)->format('H:i');

           
    //         $slotLabel = "$slotStart - $slotEnd";
         
    //         $slots[] = [
    //             'label' => $slotLabel,
    //             'disabled' => $bookedTimes->contains($slotStart),
    //         ];
            
    //         $start->addMinutes($slotGap);
    //     }
    //     }
    
      
        
    
    //     return response()->json([
    //         'from_time' => $from,
    //         'to_time' => $to,
    //         'slots' => $slots,
    //     ]);
    // }

    // public function getTime(Request $request)
    // {
    //     $carbonDate = \Carbon\Carbon::parse($request->date);
    //     $container = $request->container;
    //     $date = $carbonDate->toDateString();
    //     $day = $carbonDate->format('l');
    
    //     $slotDuration = 15;
    //     $slotGap = 15;
    //     $slots = [];
    
    //     $from = '09:00';
    //     $to = '17:00';
    
    //     $workingHour = WorkingHours::where('day', $day)->first();
    //     if ($workingHour) {
    //         $from = $workingHour->open_time;
    //         $to = $workingHour->close_time;
    //     }

    //     $from = \Carbon\Carbon::parse($from)->format('H:i'); 
    //     $to = \Carbon\Carbon::parse($to)->format('H:i');     
    
    //     $start = \Carbon\Carbon::createFromFormat('H:i', $from);
    //     $end = \Carbon\Carbon::createFromFormat('H:i', $to);
    
    //     $unavailabilities = \App\Models\DateAvailability::whereDate('date', $date)->get();
    
    //     $unavailableSlots = collect();
    
    //     foreach ($unavailabilities as $unavailability) {
    //         $blockStart = \Carbon\Carbon::parse($unavailability->start_time);
    //         $blockEnd = \Carbon\Carbon::parse($unavailability->end_time);
    
    //         $blockSlotStart = $blockStart->copy();
    //         while ($blockSlotStart->copy()->addMinutes($slotDuration)->lte($blockEnd)) {
    //             $unavailableSlots->push($blockSlotStart->format('H:i'));
    //             $blockSlotStart->addMinutes($slotGap);
    //         }
    //     }
    
    //     $bookedTimes = BookingItem::get()
    //     ->flatMap(function ($item) {
    //         $times = [];
    
    //         // Always consider pickup
    //         if ($item->pickup_date && $item->pickup_time) {
    //             $times[] = [
    //                 'date' => \Carbon\Carbon::parse($item->pickup_date)->toDateString(),
    //                 'time' => \Carbon\Carbon::parse($item->pickup_time)->format('H:i'),
    //             ];
    //         }
    
    //         // If new dropoff exists → consider only that
    //         if ($item->new_dropoff_date && $item->new_dropoff_time) {
    //             $times[] = [
    //                 'date' => \Carbon\Carbon::parse($item->new_dropoff_date)->toDateString(),
    //                 'time' => \Carbon\Carbon::parse($item->new_dropoff_time)->format('H:i'),
    //             ];
    //         }
    //         // Else fallback to old dropoff
    //         elseif ($item->dropoff_date && $item->dropoff_time) {
    //             $times[] = [
    //                 'date' => \Carbon\Carbon::parse($item->dropoff_date)->toDateString(),
    //                 'time' => \Carbon\Carbon::parse($item->dropoff_time)->format('H:i'),
    //             ];
    //         }
    
    //         return $times;
    //     })
    //     ->filter(fn($t) => $t['date'] === $date) // only take for the current date
    //     ->pluck('time')
    //     ->unique()
    //     ->values();
    
    //     $current = $start->copy();
    //     while ($current->copy()->addMinutes($slotDuration)->lte($end)) {
    //         $slotStart = $current->format('H:i');
    //         $slotEnd = $current->copy()->addMinutes($slotDuration)->format('H:i');
    //         $slotLabel = "$slotStart - $slotEnd";
    
    //         $isUnavailable = $unavailableSlots->contains($slotStart);
    //         $isBooked = $bookedTimes->contains($slotStart);
    
    //         $slots[] = [
    //             'label' => $slotLabel,
    //             'disabled' => $isUnavailable || $isBooked,
    //         ];
    
    //         $current->addMinutes($slotGap);
    //     }
    
    //     return response()->json([
    //         'from_time' => $from,
    //         'to_time' => $to,
    //         'slots' => $slots,
    //     ]);
    // }

    public function getTime(Request $request)
    {
        $carbonDate = \Carbon\Carbon::parse($request->date);
        $container = $request->container;
        $date = $carbonDate->toDateString();
        $day = $carbonDate->format('l');
    
        $slotDuration = 15;
        $slotGap = 15;
        $slots = [];
    
        $from = '09:00';
        $to = '17:00';
    
    
        if ($request->has('vendor_id') && !empty($request->vendor_id)) {
            $vendorId = $request->vendor_id;
            $carbonDay = strtolower($carbonDate->format('l')); // monday, tuesday, ...
            $dayMap = [
                'monday'    => 'mo',
                'tuesday'   => 'di',
                'wednesday' => 'mi',
                'thursday'  => 'do',
                'friday'    => 'fr',
                'saturday'  => 'sa',
                'sunday'    => 'so',
            ];
    
            $day = $dayMap[$carbonDay] ?? null;
            $workingHour = \App\Models\VendorWorkingHour::where('vendor_id', $vendorId)
            ->where('day', $day)
            ->first();
    
            if ($workingHour && !$workingHour->is_closed) {
                $from = $workingHour->open_time;
                $to = $workingHour->close_time;
            }
            $from = substr($from, 0, 5); 
            $to   = substr($to, 0, 5);
    
            $start = \Carbon\Carbon::createFromFormat('H:i', $from);
            $end = \Carbon\Carbon::createFromFormat('H:i', $to);
    
    
            $unavailabilities = \App\Models\DateAvailability::where('admin_id', $vendorId)
            ->whereDate('date', $date)
            ->get();
    
            $unavailableSlots = collect();
    
            foreach ($unavailabilities as $unavailability) {
                $blockStart = \Carbon\Carbon::parse($unavailability->start_time);
                $blockEnd = \Carbon\Carbon::parse($unavailability->end_time);
    
                $current = $start->copy();
                while ($current->copy()->addMinutes($slotDuration)->lte($end)) {
                    $slotStart = $current->copy();
                    $slotEnd = $current->copy()->addMinutes($slotDuration);
    
                    // Check for overlap with each unavailability block
                    foreach ($unavailabilities as $unavailability) {
                        $blockStart = \Carbon\Carbon::parse($unavailability->start_time);
                        $blockEnd = \Carbon\Carbon::parse($unavailability->end_time);
    
                        if ($slotStart->lt($blockEnd) && $slotEnd->gt($blockStart)) {
                            $unavailableSlots->push($slotStart->format('H:i'));
                            break; // no need to check further blocks
                        }
                    }
    
                    $current->addMinutes($slotGap);
                }
            }
    
            $bookedTimes = BookingItem::where('vendor_id', $vendorId)
            ->get()
            ->filter(fn($item) => $item->booking && $item->booking->status === 'confirmed')
            ->flatMap(function ($item) {
                $times = [];
        
                if ($item->pickup_date && $item->pickup_time) {
                    $times[] = [
                        'date' => \Carbon\Carbon::parse($item->pickup_date)->toDateString(),
                        'time' => \Carbon\Carbon::parse($item->pickup_time)->format('H:i'),
                    ];
                }
        
                if ($item->new_dropoff_date && $item->new_dropoff_time) {
                    $times[] = [
                        'date' => \Carbon\Carbon::parse($item->new_dropoff_date)->toDateString(),
                        'time' => \Carbon\Carbon::parse($item->new_dropoff_time)->format('H:i'),
                    ];
                }
                elseif ($item->dropoff_date && $item->dropoff_time) {
                    $times[] = [
                        'date' => \Carbon\Carbon::parse($item->dropoff_date)->toDateString(),
                        'time' => \Carbon\Carbon::parse($item->dropoff_time)->format('H:i'),
                    ];
                }
        
                return $times;
            })
            ->filter(fn($t) => $t['date'] === $date) 
            ->pluck('time')
            ->unique()
            ->values();
    
            $current = $start->copy();
            while ($current->copy()->addMinutes($slotDuration)->lte($end)) {
                $slotStart = $current->format('H:i');
                $slotEnd = $current->copy()->addMinutes($slotDuration)->format('H:i');
                $slotLabel = "$slotStart - $slotEnd";
    
                $isUnavailable = $unavailableSlots->contains($slotStart);
                $isBooked = $bookedTimes->contains($slotStart);
    
                $slots[] = [
                    'label' => $slotLabel,
                    'disabled' => $isUnavailable || $isBooked,
                ];
    
                $current->addMinutes($slotGap);
            }
    
    
    
    
        }else{
            $workingHour = WorkingHours::where('day', $day)->first();
            if ($workingHour) {
                $from = $workingHour->open_time;
                $to = $workingHour->close_time;
            }
    
            $from = \Carbon\Carbon::parse($from)->format('H:i');
            $to = \Carbon\Carbon::parse($to)->format('H:i');
    
            $start = \Carbon\Carbon::createFromFormat('H:i', $from);
            $end = \Carbon\Carbon::createFromFormat('H:i', $to);
    
            $unavailabilities = \App\Models\DateAvailability::where('admin_id', 1)
            ->whereDate('date', $date)
            ->get();
    
            $unavailableSlots = collect();
    
            foreach ($unavailabilities as $unavailability) {
                $blockStart = \Carbon\Carbon::parse($unavailability->start_time);
                $blockEnd = \Carbon\Carbon::parse($unavailability->end_time);
    
                $current = $start->copy();
                while ($current->copy()->addMinutes($slotDuration)->lte($end)) {
                    $slotStart = $current->copy();
                    $slotEnd = $current->copy()->addMinutes($slotDuration);
    
                    foreach ($unavailabilities as $unavailability) {
                        $blockStart = \Carbon\Carbon::parse($unavailability->start_time);
                        $blockEnd = \Carbon\Carbon::parse($unavailability->end_time);
    
                        if ($slotStart->lt($blockEnd) && $slotEnd->gt($blockStart)) {
                            $unavailableSlots->push($slotStart->format('H:i'));
                            break; 
                        }
                    }
    
                    $current->addMinutes($slotGap);
                }
            }
    
            $bookedTimes = BookingItem::whereNull('vendor_id')
            ->get()
            ->filter(fn($item) => $item->booking && $item->booking->status === 'confirmed')
            ->flatMap(function ($item) {
                $times = [];
    
                // Always consider pickup
                if ($item->pickup_date && $item->pickup_time) {
                    $times[] = [
                        'date' => \Carbon\Carbon::parse($item->pickup_date)->toDateString(),
                        'time' => \Carbon\Carbon::parse($item->pickup_time)->format('H:i'),
                    ];
                }
    
                // If new dropoff exists → consider only that
                if ($item->new_dropoff_date && $item->new_dropoff_time) {
                    $times[] = [
                        'date' => \Carbon\Carbon::parse($item->new_dropoff_date)->toDateString(),
                        'time' => \Carbon\Carbon::parse($item->new_dropoff_time)->format('H:i'),
                    ];
                }
                // Else fallback to old dropoff
                elseif ($item->dropoff_date && $item->dropoff_time) {
                    $times[] = [
                        'date' => \Carbon\Carbon::parse($item->dropoff_date)->toDateString(),
                        'time' => \Carbon\Carbon::parse($item->dropoff_time)->format('H:i'),
                    ];
                }
    
                return $times;
            })
            ->filter(fn($t) => $t['date'] === $date) 
            ->pluck('time')
            ->unique()
            ->values();
    
            $current = $start->copy();
            while ($current->copy()->addMinutes($slotDuration)->lte($end)) {
                $slotStart = $current->format('H:i');
                $slotEnd = $current->copy()->addMinutes($slotDuration)->format('H:i');
                $slotLabel = "$slotStart - $slotEnd";
    
                $isUnavailable = $unavailableSlots->contains($slotStart);
                $isBooked = $bookedTimes->contains($slotStart);
    
                $slots[] = [
                    'label' => $slotLabel,
                    'disabled' => $isUnavailable || $isBooked,
                ];
    
                $current->addMinutes($slotGap);
            }
        }
    
        return response()->json([
            'from_time' => $from,
            'to_time' => $to,
            'slots' => $slots,
        ]);
    }
    
    
    public function showDetails($id, $itemid)
    {
        $booking = Booking::with([
            'items' => function ($query) use ($itemid) {
                $query->where('id', $itemid);
            },
            'userDetails'
        ])
        ->where('id', $id)
        ->where('user_id', Auth::id())
        ->firstOrFail();
    
        return view($this->file_path . 'appointment.details', compact('booking'));
    }

    public function getDetails($id,$itemid){
        $booking = Booking::with([
            'items' => function ($query) use ($itemid) {
                $query->where('id', $itemid);
            },
            'userDetails'
        ])
        ->where('id', $id)
        ->where('user_id', Auth::id())
        ->firstOrFail();

        return response()->json([
            'booking' => $booking
        ]);
    }

    public function updateAppointment(Request $request, $id,$itemid)
    {

        $request->validate([
            'pickup_date' => 'required|date',
            'dropoff_date' => 'required|date|after_or_equal:pickup_date',
            'pickup_time' => 'required',
            'dropoff_time' => 'required',
            'reason' => 'nullable|string|max:500'
        ]);

        $booking = Booking::with([
            'items' => function ($query) use ($itemid) {
                $query->where('id', $itemid);
            }
        ])
            ->where('id', $id)
            ->where('user_id', Auth::id())
            ->firstOrFail();

            $booking = Booking::where('id', $id)->with('items')->firstOrFail();


        


        // $pickupDateTime = Carbon::parse($request->pickup_date . ' ' . $request->pickup_time);
        // if ($pickupDateTime->diffInHours(Carbon::now()) < 48) {
        //     return response()->json([
        //         'success' => false,
        //         'message' => 'You cannot change your appointment within 48 hours of pickup.'
        //     ], 422);
        // }

        foreach ($booking->items as $item) {
            $item->update([
                'pickup_date' => $request->pickup_date,
                'dropoff_date' => $request->dropoff_date,
                'pickup_time' => $request->pickup_time,
                'dropoff_time' => $request->dropoff_time
            ]);
        }

        if ($request->reason) {
            ActivityLog::create([
                'user_id' => Auth::id(),
                'action' => 'appointment_change',
                'description' => 'Appointment changed for booking #' . $booking->id,
                'details' => $request->reason
            ]);
        }

        return response()->json([
            'success' => true,
            'message' => 'Appointment updated successfully!'
        ]);
    }
}
