<?php

namespace App\Http\Controllers\Frontend\Auth;

use Illuminate\Support\Facades\Hash;
use App\Http\Controllers\Controller;
use App\Models\User;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Facades\Auth;


use Illuminate\Http\Request;

class SocialiteController extends Controller
{
    public function googleLogin(){
        return Socialite::driver('google')->redirect();
    }


    public function googleCallback()
    {
        $googleUser = Socialite::driver('google')->stateless()->user();
    
        $user = User::where('google_id', $googleUser->id)->first();
    
        if (!$user) {
            $user = User::where('email', $googleUser->email)->first();
    
            if ($user) {
                $user->update([
                    'google_id' => $googleUser->id,
                    'profile_image' => $googleUser->avatar
                ]);
            } else {
                $user = User::create([
                    'first_name' => $googleUser->name,
                    'last_name' => '',
                    'email' => $googleUser->email,
                    'google_id' => $googleUser->id,
                    'profile_image' => $googleUser->avatar,
                    'status' => 1,
                    'password' => Hash::make('Password@1234'),
                    'street' => '',
                    'zip_code' => '',
                    'city' => '',
                    'region' => ''
                ]);
            }
        }
    
        Auth::login($user);
    
        $timestamp = session('rental_form_timestamp');
        $fromRentNow = session('from_rent_now');

    
        if ($fromRentNow && $timestamp) {
            $minutesSince = now()->diffInMinutes(Carbon::parse($timestamp));
    
            if ($minutesSince <= 10) {
                session()->forget(['from_rent_now', 'rental_form_timestamp']);
                return redirect()->route('cart.process.session');
            }
        }
    
        session()->forget(['from_rent_now', 'rental_form_timestamp']);
    
        return redirect()->route('home')->with('success', 'Login successful!');
    }
    
    
    
    
    
    
    
    
}
