<?php

namespace App\Http\Controllers\Frontend\Check;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Log;
use App\Models\CartItem;
use Session;
use App\Models\User;
use App\Models\UserAddressDetail;
class CheckoutController extends Controller
{
    public $file_path = 'frontend.checkout.';

    public function index(Request $request)
    {

        try {
            $is_guest = false;
            if(Auth::user()){
                $user_id = Auth::id();
            }else{
                $user_id =  Session::get('guest_user')->id;
                $is_guest = true;
            }

            
            
            User::where('id', $user_id)->update([
                'marketing_aggrement' => $request->marketing_checkbox == 1 ? 1 : 0
            ]);


            $cartItems = CartItem::where('user_id', $user_id)
            ->where('status', 'pending')
            ->with('product')
            ->get();
        
        $taxRate = 0.19;
        $onePlus = 1 + $taxRate;
        $insuranceFlatRate = 25.00;
        
        // --- totals (gross) ---
        $grossBeforeDiscount = $cartItems->sum('calculated_rent');
        $discount            = (float) $cartItems->sum('discount'); // discount applies to total gross
        $grossTotal          = max($grossBeforeDiscount - $discount, 0.0); // this is your TOTAL
        
        // insurance gross (flat 25 per insured item) – NOT reduced by discount
        $insuranceCount = $cartItems->where('is_insured', true)->count();
        $insuranceGross = $insuranceCount * $insuranceFlatRate;
        
        // --- nets & tax ---
        $netSubtotal         = $grossTotal / $onePlus;              // “Subtotal” (net, tax-free)
        $insuranceNetTotal   = $insuranceGross / $onePlus;          // “Net Price Insurance”
        $rentalNet           = max($netSubtotal - $insuranceNetTotal, 0.0); // “Net Price” (rent only)
        $tax                 = $grossTotal - $netSubtotal;          // total VAT (includes insurance VAT)
        
        // optional: set item-level rent net/tax (discount spread only over the rental part)
        $totalRentalGrossBeforeDiscount = $cartItems->sum(function ($it) use ($insuranceFlatRate) {
            return $it->calculated_rent - ($it->is_insured ? $insuranceFlatRate : 0);
        });
        
        $cartItems->each(function ($item) use ($onePlus, $insuranceFlatRate, $discount, $totalRentalGrossBeforeDiscount) {
            $baseRentalGross = $item->calculated_rent - ($item->is_insured ? $insuranceFlatRate : 0);
            $share = $totalRentalGrossBeforeDiscount > 0 ? ($baseRentalGross / $totalRentalGrossBeforeDiscount) : 0;
            $itemRentalGrossAfterDiscount = max($baseRentalGross - ($discount * $share), 0.0);
        
            $item->net_price  = $itemRentalGrossAfterDiscount / $onePlus;         // rent net (per item)
            $item->tax_amount = $itemRentalGrossAfterDiscount - $item->net_price; // rent VAT (per item)
            // (Insurance per-item net/tax available if you need them:
            // $item->insurance_net = $item->is_insured ? ($insuranceFlatRate / $onePlus) : 0;
            // $item->insurance_tax = $item->is_insured ? ($insuranceFlatRate - $item->insurance_net) : 0;
        });
            $view = 'index';
            if($is_guest){
                $view = 'guest';
            }

            $billingAddresses = [];
            $defaultAddress = null;
            $formValues = [];

            
            if (!$is_guest) {
                $user = Auth::user();
                $billingAddresses = UserAddressDetail::where('user_id', $user->id)->get();
                
                if (!UserAddressDetail::where('user_id', $user->id)->where('is_default', true)->exists()) {
                    $latest = UserAddressDetail::where('user_id', $user->id)->latest()->first();
                    if ($latest) {
                        $latest->is_default = true;
                        $latest->save();
                    }
                }
                
                $defaultAddress = UserAddressDetail::where('user_id', $user->id)
                    ->where('is_default', true)
                    ->first();
         
            
            $formValues = [
                'email' => $user->email ?? '',
                'first_name' => $user->first_name ?? '',
                'last_name' => $user->last_name ?? '',
                'company_name' => $user->company_name ?? '',
                'address' => $user->street ?? '',
                'zip' => $user->zip_code ?? '',
                'city' => $user->city ?? '',
                'region' => $user->region ?? '',
                'phone_code' => $user->phone_code ?? '+49',
                'phone_number' => $user->number ?? '',
            ];
            
            if ($defaultAddress) {
                $nameParts = explode(' ', $defaultAddress->name, 2);
                
                $formValues = [
                    'email' => $defaultAddress->email ?? $user->email,
                    'first_name' => $nameParts[0] ?? '',
                    'last_name' => $nameParts[1] ?? '',
                    'company_name' => $defaultAddress->company_name ?? '',
                    'address' => $defaultAddress->street ?? '',
                    'zip' => $defaultAddress->zipcode ?? '',
                    'city' => $defaultAddress->city ?? '',
                    'region' => $defaultAddress->state ?? $user->region  ,
                    'phone_code' => $defaultAddress->phone_code ?? '+49',
                    'phone_number' => $defaultAddress->contact_number ?? '',
                ];
            }
    
        }

            
    
            return view($this->file_path . $view, [
                'cartItems' => $cartItems,
                'subtotal' => $netSubtotal,
                'discount' => $discount,
                'insuranceTotal' => $insuranceNetTotal,
                'tax' => $tax,
                'netPrice' => $rentalNet,
                'total' => $grossTotal,
                'billingAddresses' => $billingAddresses,
                'defaultAddress' => $defaultAddress,
          
                'formValues' => $formValues,
            ]);
                
        } catch (\Exception $e) {
            Log::error('Cart Error: ' . $e->getMessage());
            dd($e->getMessage());
            return redirect()->back()->with('error', 'Something went wrong! Please try again later.');
        }
    }

   
    

    


}
