<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ContactUs;
use Exception;
use Illuminate\Support\Facades\Mail;
use App\Mail\ContactMail;
use App\Models\Notification;
use App\Models\BookingItem;
class ContactController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name'    => 'required|string|max:100',
            'email'   => 'required|email',
            'number'  => 'required|string|max:20',
            'message' => 'required|string|max:1000',
        ], [
            'name.required'    => 'Please enter name.',
            'email.required'   => 'Please enter email.',
            'email.email'      => 'Please enter a valid email address.',
            'number.required'  => 'Please enter contact number.',
            'message.required' => 'Please enter your message.',
        ]);

        try {
            $contact = ContactUs::create($validated);

            $bookingId = $request->input('booking_id');
            $itemId = $request->input('item_id');

            $pickupDateTime = null;
            $dropoffDateTime = null;

            if ($bookingId && $itemId) {
                $booking = \App\Models\Booking::with(['items' => function ($q) use ($itemId) {
                    $q->where('id', $itemId);
                }, 'userDetails'])->find($bookingId);
            
                $item = $booking?->items?->first();
                if ($item) {
                    $pickupDate = \Carbon\Carbon::parse($item->pickup_date)->format('d.m.Y');
                    $pickupTime = $item->pickup_time ? \Carbon\Carbon::createFromFormat('H:i:s', $item->pickup_time)->format('H:i') : null;
                
                    $dropoffDate = \Carbon\Carbon::parse($item->dropoff_date)->format('d.m.Y');
                    $dropoffTime = $item->dropoff_time ? \Carbon\Carbon::createFromFormat('H:i:s', $item->dropoff_time)->format('H:i') : null;
                
                    $pickupDateTime = $pickupDate . ($pickupTime ? ' | ' . $pickupTime : '');
                    $dropoffDateTime = $dropoffDate . ($dropoffTime ? ' | ' . $dropoffTime : '');


                    $bookingItems = BookingItem::where('booking_id', $booking->id)->get();
                     $vendorIds = $bookingItems->pluck('vendor_id')->filter()->unique();
               
                     if ($vendorIds->isNotEmpty()) {
                        foreach ($vendorIds as $vendorId) {
                        Notification::create([
                            'type' => 'user_slot_change_request',
                            'status' => 'User Slot Change Request', 
                            'user_id' => auth()->id(),
                            'customer_name' => $validated['name'],
                            'customer_email' => $validated['email'],
                            'customer_phone' => $validated['number'],
                            'vendor_id' => $vendorId,

                            'data' => [
                                ['label' => 'Query ID', 'value' => '#' . $contact->id],
                                ['label' => 'Booking ID', 'value' => '#' . $bookingId],
                                ['label' => 'PickUp Date Time', 'value' => $pickupDateTime],
                                ['label' => 'DropOff Date Time', 'value' => $dropoffDateTime],
                                ['label' => 'Message', 'value' => $validated['message']],
                             
                            ],

                            'is_read' => false,
                        ]);
                    }
                    }else{
                        Notification::create([
                            'type' => 'user_slot_change_request',
                            'status' => 'User Slot Change Request', 
                            'user_id' => auth()->id(),
                            'customer_name' => $validated['name'],
                            'customer_email' => $validated['email'],
                            'customer_phone' => $validated['number'],
                            'data' => [
                                ['label' => 'Query ID', 'value' => '#' . $contact->id],
                                ['label' => 'Booking ID', 'value' => '#' . $bookingId],
                                ['label' => 'PickUp Date Time', 'value' => $pickupDateTime],
                                ['label' => 'DropOff Date Time', 'value' => $dropoffDateTime],
                                ['label' => 'Message', 'value' => $validated['message']],
                             
                            ],
                            'is_read' => false,
                        ]);
                    }
                }
            }else{
                Notification::create([
                    'type' => 'new_Query',
                    'status' => 'New Query', 
                    'user_id' => auth()->id(),
                    'customer_name' => $validated['name'],
                    'customer_email' => $validated['email'],
                    'customer_phone' => $validated['number'],
                    'data' => [
                        ['label' => 'Query ID', 'value' => '#' . $contact->id],
                        ['label' => 'Message', 'value' => $validated['message']],
                     
                    ],
                    'is_read' => false,
                ]);
            }
          

            Mail::to($validated['email'])->send(new ContactMail($contact));

            return redirect()->back()->with('success', 'Thank you for contacting us.');
        } catch (Exception $e) {
            return redirect()->back()
                ->with(['message' => 'An error occurred while processing your request.', 'alert-type' => 'error']);
        }
}
}
