<?php

namespace App\Http\Controllers\Frontend\Newsletter;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Services\MailchimpService;

class NewsletterController extends Controller
{
    protected $mailchimp;

    public function __construct(MailchimpService $mailchimp)
    {
        $this->mailchimp = $mailchimp;
    }

    public function subscribe(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
        ]);

        try {
            $result = $this->mailchimp->subscribe($request->email);

            if ($result['status'] === 'subscribed' || $result['status'] === 'resubscribed') {
                return back()->with('success', $result['message']);
            }

            if ($result['status'] === 'already_subscribed') {
                return back()->with('info', $result['message']);
            }

            return back()->with('error', $result['message']);

        } catch (\Exception $e) {
            dd($e->getMessage());
            return back()->with('error', 'Something went wrong. Please try again later.');
        }
    }


    public function toggleNewsletter(Request $request)
    {
        $email = auth()->user()->email;

        if ($this->mailchimp->isSubscribed($email)) {
            $message = $this->mailchimp->unsubscribe($email);
            return back()->with('success', 'Unsubscribed Successfully');
        } else {
            $message = $this->mailchimp->subscribe($email);
             if($message['status'] == 'subscribed'){
                return back()->with('success', $message['message']);

           }else{
                return back()->with('error',  $message['message']);
           }   
        }
    }
    
}
