<?php

namespace App\Http\Controllers\Frontend\Payment;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Log;
use Stripe\Webhook;

class StripeWebhookController extends Controller
{
    public function handle(Request $request) {
        $payload = $request->getContent();
        $event = json_decode($payload, true); 

        switch ($event['type']) {
            case 'checkout.session.completed':
                # code...
                break;
            case 'payment_intent.succeeded':
                if (isset($event['data']['object']['status'])){
                    if ($event['data']['object']['status'] === 'succeeded') {
                        Log::info('✅ Payment intent id', [
                            'id' => $event['data']['object']['id'],
                           
                        ]);
                    }
                }
                break;
            case 'payment_intent.payment_failed':
                # code...
                break;
            
            default:
                # code...
                break;
        }
        Log::info('✅ Stripe Webhook Received', [
            'event_type' => $event['type'] ?? 'unknown',
            'full_event' => $event
        ]);
    }
}
