<?php

namespace App\Http\Controllers\Frontend\Voucher;

use App\Http\Controllers\Controller;
use App\Models\Voucher;
use Illuminate\Http\Request;

class VoucherController extends Controller
{
    public function index(Request $request)
    {
        $userId = auth()->id();

        $vouchers = Voucher::whereDate('expiration_date', '>=', now()->subDays(14))
            ->orderBy('expiration_date', 'asc')
            ->get();

        return view('frontend.user.voucher.index', compact('vouchers', 'userId'));
    }
}
