<?php

namespace App\Http\Controllers;

use App\Imports\MotherFileImport;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\MotherFileExport;

use Illuminate\Http\Request;
use App\Models\MotherFile;

class MotherFileController extends Controller
{
        public function importForm()
    {

        return view('admin.settings.index');
        return view('roofracks.import');
    }

    public function import(Request $request)
    {
        $request->validate([
            'file' => 'required|mimes:xlsx,xls,csv'
        ]);

        MotherFile::truncate();

        Excel::import(new MotherFileImport, $request->file('file'));

        return back()->with('success', 'Excel Imported Successfully!');
    }

    public function export()
    {
        return Excel::download(new MotherFileExport, 'mother_file.csv');
    }
}


