<?php

namespace App\Http\Controllers\Vendor\Notification;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Notification;
use Illuminate\Support\Facades\Auth;

class NotificationController extends Controller
{
    /**
     * Show all notifications
     */
    // public function index(Request $request)
    // {
    //     $query = Notification::with('user'); // Load user relationship
    
    //     if ($request->has('unread')) {
    //         $query->where('is_read', false);
    //     }
    
    //     $notifications = $query->latest()->paginate(20);
    //     return view('admin.notifications.index', compact('notifications'));
    // }

    public function index(Request $request)
    {
        $vendor = Auth::guard('vendor')->user();

        $query = Notification::query();
        $query->where('vendor_id',$vendor->id);
       
    
        if ($request->filled('type')) {
            $query->where('type', $request->type);
        }
    
        $query->orderBy('created_at', 'desc');
    
        $notifications = $query->paginate(10)->appends($request->query());
    
        $types = Notification::select('type')->distinct()->pluck('type');
    
        return view('vendor.notifications.index', compact('notifications', 'types'));
    }

    

    /**
     * Fetch latest notifications via AJAX
     */
    public function fetch(Request $request)
    {
        $vendor = Auth::guard('vendor')->user();
        $notifications = Notification::latest()->take(10)->get();
        $unreadNotifications = Notification::where('is_read', false)
        ->where('vendor_id',$vendor->id)
        ->latest()
        
        ->get();
        return response()->json([
            'success' => true,
            'unread_count' => $unreadNotifications->count(),
            'notifications' => $notifications->map(function ($notification) {
                return [
                    'id' => $notification->id,
                    'title' => $notification->status,
                    'status' => $notification->status,
                    'type' => $notification->type,
                    'data' => $notification->data,
                    'customer_name' => $notification->customer_name,
                    'customer_email' => $notification->customer_email,
                    'customer_phone' => $notification->customer_phone,
                    'created_at' => $notification->created_at->diffForHumans(),
                    'is_read' => $notification->is_read,
                ];
            }),
        ]);
    }

    /**
     * Mark a specific notification as read
     */
    public function markAsRead($id)
    {
        try {
            $notification = Notification::findOrFail($id);
            $notification->markAsRead();

            return redirect()->back()->with('success', 'Notification marked as read.');
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Unable to mark notification as read.',
            ], 500);
        }
    }

    public function markAsUnread($id)
    {
        try {
            $notification = Notification::findOrFail($id);
            $notification->update(['is_read' => false]);

            return redirect()->back()->with('success', 'Notification marked as unread.');
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Unable to mark notification as unread.',
            ], 500);
        }
    }

    public function markAllAsRead()
    {
        Notification::where('is_read', false)->update(['is_read' => true]);

        return redirect()->back()->with('success', 'All notifications marked as read.');
    }
}
