<?php

namespace App\Imports;

use App\Models\Bundle;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Row;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithCustomCsvSettings;
use Maatwebsite\Excel\Concerns\WithStartRow;

class BundleFileImport implements OnEachRow, WithHeadingRow,WithStartRow
{
    

    public function startRow(): int
    {
        return 3; // Skip the first row
    }

    public function onRow(Row $row)
    {
        $r = $row->toArray();


        \App\Models\Bundle::create([
            'car_make' => $r[0] ?? null,
            'model' => $r[1] ?? null,
            'type_year' => $r[2] ?? null,
            'rooftype_ger' => $r['roof_type_name'] ?? null,
            'rooftype_eng' => $r[4] ?? null,
            'recommended_roofbox_size' => $r[5] ?? null,
            'carrier_length' => $r[6] ?? null,
            'foot_sku' => $r['roof_rack'] ?? null,
            'footkit_sku' => $r[8] ?? null,
            'product_category' => $r[9] ?? null,
            'bundle_name' => $r[10] ?? null,
            'description' => $r[11] ?? null,
        ]);
    }
}
