<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\Admin;
class AdminBookingPaymentLink extends Mailable
{
    use Queueable, SerializesModels;
    public $booking;
    public $customer;
    public $product_name;
    public $rental_period;
    public $total_amount;
    public $payment_link;
    public $admin;
    public $userDetails;
    public $bookingItems;

    public function __construct($booking, $customer, $product_name, $rental_period, $total_amount, $payment_link)
    {
        $this->booking = $booking;
        $this->customer = $customer;
        $this->product_name = $product_name;
        $this->rental_period = $rental_period;
        $this->total_amount = $total_amount;
        $this->payment_link = $payment_link;
        $this->admin = Admin::first();
        $this->userDetails = $userDetails;
        $this->bookingItems = $bookingItems;

    }

    public function build()
    {
        return $this->subject('Zahlungslink für Ihre Buchung bei Dachboxmiete – 24 Stunden gültig')
                    ->view('email.admin-booking-payment-link');
    }
    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
