<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\Admin;

class GuestAccountMail extends Mailable
{
    use Queueable, SerializesModels;

    public $email;
    public $password;
    public $admin;

    public function __construct($email, $password)
    {
        $this->email = $email;
        $this->password = $password;
        $this->admin = Admin::first();
    }

    public function build()
    {
        return $this->subject('Your Customer Account Details')
                    ->view('email.guest-account');
    }
}