<?php

namespace App\Mail;

use App\Models\Booking;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\Admin;


class PreferredTimings extends Mailable
{
    use Queueable, SerializesModels;

    public $booking;
    public $userDetails;
    public $bookingItems;
    public $admin;
    public $vendor;
    public function __construct(Booking $booking, $userDetails, $bookingItems , $vendor = null)
    {
        $this->booking = $booking;
        $this->userDetails = $userDetails;
        $this->bookingItems = $bookingItems;
        $this->admin = Admin::first();
        $this->vendor = $vendor;
    }

    public function build()
    {
        return $this->subject('Preferred timings for your booking #' . $this->booking->invoice_number)
           ->markdown('email.preferred_timings');
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
