<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\Admin;

class AdminForgetMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $token;
    protected $name;
    public $admin;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($token, $name)
    {

        $this->token = $token;
        $this->name = $name;
        $this->admin = Admin::first();
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject('reset password link')
                    ->view('email.password-reset-link') 
                    ->with([
                        'link' => route('admin.password.reset',$this->token),
                        'name' => $this->name,
                        'admin' => $this->admin,
                    ]);;
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
