<?php

namespace App\Mail;

use App\Models\Admin;
use App\Models\Vendor;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Services\LegalDocumentService;

class ConfirmationEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $booking;
    public $bookingItems;
    public $userDetails;
    public $termsPdf;
    public $privacyPdf;
    public $withdrawlPdf;
    public $admin;
    public $vendor;

    public function __construct($booking, $bookingItems, $userDetails,$vendor_id = null)
    {
        $this->booking = $booking;
        $this->bookingItems = $bookingItems;
        $this->userDetails = $userDetails;
        
        $legalService = new LegalDocumentService();
        $this->termsPdf = $legalService->generateTermsAndConditions();
        $this->privacyPdf = $legalService->generatePrivacyPolicy();
        $this->withdrawlPdf = $legalService->generateWithdrawlPolicy();

        $this->admin = Admin::first();

        if($vendor_id){
            $this->vendor = Vendor::where('id',$vendor_id)->first(); 
        }
    }
    
    public function build()
    {
        return $this->subject(__('messages.confirmation_header'))
                    ->markdown('email.confirmation')

                    ->attachData($this->termsPdf->output(), __('messages.terms_pdf'))
                    ->attachData($this->privacyPdf->output(), __('messages.privacy_pdf'))
                    ->attachData($this->withdrawlPdf->output(), __('messages.withdrawal_pdf'))
                    ->with([
                        'booking' => $this->booking,
                        'bookingItems' => $this->bookingItems,
                        'userDetails' => $this->userDetails,
                        'admin' => $this->admin,
                        'vendor' => $this->vendor
                    ]);
    }
}