<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\Admin;

class ContactMail extends Mailable
{
    use Queueable, SerializesModels;
    
    protected $detail;
    public $admin;
    /**
     * Create a new message instance.
     */
    public function __construct($detail)
    {   
        $this->detail = $detail;
        $this->admin = Admin::first();
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject(__('messages.contact_email_subject'))
                    ->view('email.contact-us')
                    ->with([
                        'data' => $this->detail,
                        'admin' => $this->admin
                    ]);
    }

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [];
    }
}
