<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ForgetPasswordMail extends Mailable
{
    use Queueable, SerializesModels;

    protected $token;
    protected $name;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($token, $name)
    {

        $this->token = $token;
        $this->name = $name;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->subject(__('messages.reset_password_link'))
                    ->view('email.password-reset-link') 
                    ->with([
                        'link' => route('coach.password.reset',$this->token),
                        'name' => $this->name,
                    ]);;
    }

    /**
     * Get the attachments for the message.
     *
     * @return array
     */
    public function attachments()
    {
        return [];
    }
}
