<?php

namespace App\Mail;

use App\Models\Admin;
use App\Models\Booking;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Services\LegalDocumentService;
use App\Models\Vendor;

class InvoiceEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $invoiceNumber;
    public $invoiceDate;
    public $booking;
    // Add these new properties
    public $issuer;
    public $recipient;
    public $bookingItems;
    public $subtotal;
    public $tax;
    public $total;
    public $paymentMethod;
    public $pdf;
    public $userDetails;
    public $admin;
    public $vendor;

    public function __construct(
        string $invoiceNumber,
        $invoiceDate,
        Booking $booking,
        array $issuer,
        array $recipient,
        $bookingItems,
        float $subtotal,
        float $tax,
        float $total,
        string $paymentMethod,
        $pdf,
        $userDetails,
        $vendor_id = null
    ) {
        $this->invoiceNumber = $invoiceNumber;
        $this->invoiceDate = $invoiceDate;
        $this->booking = $booking;
        $this->issuer = $issuer;
        $this->recipient = $recipient;
        $this->bookingItems = $bookingItems;
        $this->subtotal = $subtotal;
        $this->tax = $tax;
        $this->total = $total;
        $this->paymentMethod = $paymentMethod;
        $this->pdf = $pdf;
        $this->userDetails = $userDetails;
        $this->admin = Admin::first();

        if($vendor_id){
            $this->vendor = Vendor::where('id',$vendor_id)->first(); 
        }
    }

    public function build()
    {
        $legalService = new LegalDocumentService();
        $admin = Admin::first();

        return $this->subject(__('messages.invoice_header') . $this->invoiceNumber)
            ->markdown('email.invoice')
            ->attachData($this->pdf->output(), __('messages.invoice_header') . $this->invoiceNumber . '.pdf')
            ->attachData($legalService->generateTermsAndConditions()->output(), __('messages.file_terms'))
            ->attachData($legalService->generateWithdrawlPolicy()->output(), __('messages.file_withdrawal'))
            ->attachData($legalService->generateGdpr()->output(), __('messages.file_privacy'))
            ->with([
                'invoiceNumber' => $this->invoiceNumber,
                'invoiceDate' => $this->invoiceDate,
                'booking' => $this->booking,
                'issuer' => $this->issuer,
                'recipient' => $this->recipient,
                'bookingItems' => $this->bookingItems,
                'subtotal' => $this->subtotal,
                'tax' => $this->tax,
                'total' => $this->total,
                'paymentMethod' => $this->paymentMethod,
                'userDetails' => $this->userDetails,
                'admin' => $this->admin,
                'vendor' => $this->vendor
            ]);
    }
}