<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use App\Models\Admin;

class UserForgotPassword extends Mailable
{
    use Queueable, SerializesModels;

    protected $token;
    protected $firstName;
    protected $lastName;
    public $admin;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($token, $firstName,$lastName)
    {

        $this->token = $token;
        $this->firstName = $firstName;
        $this->lastName = $lastName;
        $this->admin = Admin::first();
    }
    public function build()
    {
                return $this->subject(__('messages.reset_password_link'))
                    ->view('email.password-reset-link') 
                    ->with([
                        'link' => route('reset.password.view', ['token' => $this->token]),
                        'name' => $this->firstName.' '.$this->lastName,
                        'admin' => $this->admin,
                    ]);
    }
}
