<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\Admin;

class VerifyEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $verificationUrl;
    public $admin;
    public $name;

    public function __construct($verificationUrl , $name)
    {
        $this->verificationUrl = $verificationUrl;
        $this->admin = Admin::first();
        $this->name = $name;
    }

    public function build()
    {
        return $this->subject(__('messages.verify_your_email'))
            ->view('email.emailVerificationEmail')
            ->with(['verificationUrl' => $this->verificationUrl,
            'admin' => $this->admin,
            'name' => $this->name,
        
        
        ]);
    }
}

