<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Booking extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'status',
        'subtotal',
        'discount',
        'tax',
        'total',
        'payment_method',
        'payment_status',
        'stripe_session_id',
        'stripe_payment_intent',
        'cancellation_reason',
        'coupon_code',
        'last_payment_link_sent_at',
        'invoice_number',
        'refund_amount',
        'vendor_id',
        'delay',
         'delay_fees',
         'additional_days',
         'new_dropoff_date',
         'damage',
         'additional_days_rent',
         'delay_session_id',
         'last_delay_payment_link_sent_at',
         'delay_fees_paid',
         'notes',
         
    ];

    protected $casts = [
        'subtotal' => 'decimal:2',
        'discount' => 'decimal:2',
        'tax' => 'decimal:2',
        'total' => 'decimal:2',
        'refund_amount' => 'decimal:2',
        'delay_fees' => 'decimal:2',
        'additional_days_rent' => 'decimal:2',
        'damage' => 'boolean',
        'delay' =>'boolean'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function items()
    {
        return $this->hasMany(BookingItem::class);
    }

    public function userDetails()
    {
        return $this->hasOne(BookingUserDetail::class);
    }

    public function scopePaid($query)
    {
        return $query->where('payment_status', 'paid');
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }
    
    public function getFormattedTotalAttribute()
    {
        return '€' . number_format($this->total, 2);
    }
    public function voucher() {
        return $this->belongsTo(Voucher::class);
    }
    public function bookingItems()
    {
        return $this->hasMany(BookingItem::class);
    }
}