<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookingItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'booking_id',
        'user_id',
        'product_id',
        'product_name',
        'car_name',
        'car_year',
        'model',
        'trailer_hitch',
        'roof_type',
        'color',
        'size',
        'is_carrier_included',
        'is_insured',
        'pickup_date',
        'dropoff_date',
        'pickup_time',
        'dropoff_time',
        'days',
        'footkit_sku',
        'foot_sku',
        'carrier_length',
        'calculated_rent',
        'status',
        'user_timing',
        'vendor_id',
        'booking_item_id',
        'already_booked',
        'damage',
        'delay',
        'new_dropoff_date',
        'additional_days',
        'change_reason',
        'new_dropoff_time',
        'additional_days_rent',
        'related_item',
        'is_roof_rack_product',
        'booking_request_id',
         'pickup_end',
        'dropoff_end'
    ];

    protected $casts = [
        'trailer_hitch' => 'boolean',
        'is_carrier_included' => 'boolean',
        'is_insured' => 'boolean',
        'pickup_date' => 'date',
        'dropoff_date' => 'date',
        'calculated_rent' => 'decimal:2',
        'additional_days_rent' => 'decimal:2',
        'damage' => 'boolean',
        'is_roof_rack_product' =>'boolean'
    ];

    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}