<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookingRequest extends Model
{
    use HasFactory;

    protected $table = 'booking_requests';

    protected $fillable = [
        'booking_request_id',
        'customer_name',
        'customer_email',
        'customer_phone',
        'product_name',
        'color_name',
        'size_or_variation',
        'carrier_length',
        'foot_sku',
        'footkit_sku',
        'manufacturer',
        'car_model',
        'car_year',
        'trailer_hitch',
        'roof_type',
        'rental_from',
        'rental_to',
        'pickup_location',
        'city',
        'zipcode',
        'street',
        'state',
        'unavailable_components',
        'message',
    ];

    /**
     * Example relationship: if you want to link booking requests
     * with notifications in the future
     */
    public function notifications()
    {
        return $this->hasMany(Notification::class, 'booking_request_id', 'booking_request_id');
    }
}