<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BookingUserDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'booking_id',
        'first_name',
        'last_name',
        'email',
        'phone',
        'address',
        'zip',
        'city',
        'country',
        'user_id',
        'company_name',
    ];

    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }
}