<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DateAvailability extends Model
{
    use HasFactory;
    protected $table = 'date_availability';

    protected $fillable = [
        'admin_id',
        'date',
        'start_time',
        'end_time',
        'is_closed'
    ];

    protected $casts = [
        'date' => 'date',
        'start_time' => 'datetime:H:i',
        'end_time' => 'datetime:H:i',
    ];
}