<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Notification extends Model
{
    use HasFactory;

    protected $fillable = [
        'type',
        'status',
        'user_id',
        'customer_name',
        'customer_email',
        'customer_phone',
        'data',
        'vendor_id',
        'is_read',
    ];

    protected $casts = [
        'data' => 'array',
        'is_read' => 'boolean',
    ];


    public function user()
    {
        return $this->belongsTo(User::class);
    }


    public function scopeUnread($query)
    {
        return $query->where('is_read', false);
    }


    public function markAsRead()
    {
        $this->update(['is_read' => true]);
    }


    public function getTitleAttribute()
    {
        return match ($this->type) {
            'payment_link_sent'        => 'Payment Link Sent',
            'payment_link_paid'        => 'Payment Completed',
            'payment_link_expired'     => 'Payment Link Expired',
            'contact_us'               => 'Customer Inquiry',
            'slot_change_request'      => 'Slot Change Requested',
            'slot_change_request_failed' => 'Slot Change Failed',
            'booking_cancellation'     => 'Booking Cancelled - User Account',
            'voucher_expired'          => 'Voucher Expired',
            'voucher_limit_reached'    => 'Voucher Limit Reached',
            'newsletter_unsubscribed'  => 'Unsubscribed From Newsletter',
            default                    => ucwords(str_replace('_', ' ', $this->type)),
        };
    }
}
