<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Cviebrock\EloquentSluggable\Sluggable;

class Product extends Model
{
    use HasFactory;
    use Sluggable;

    protected $guarded = [];
    
    protected $fillable = ['name', 'description', 'category_id', 'brand_id', 'keywords','weight','status','length','width','height','max_load','volume','railing_type'];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function brand()
    {
        return $this->belongsTo(ProductBrand::class, 'brand_id');
    }

    public function variations()
    {
        return $this->hasMany(ProductVariation::class);
    }

    public function images()
    {
        return $this->hasMany(ProductImage::class);
    }

    public function models()
    {
        return $this->hasMany(ProductModel::class);
    }

    public function otherInfos()
    {
        return $this->hasMany(ProductOtherInfo::class);
    }
    public function otherInfo()
    {
        return $this->hasMany(ProductOtherInfo::class, 'product_id');
    }

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'meta_title'
            ]
        ];
    }
    public function mainPhoto()
    {
        return $this->hasOne(ProductImage::class)->where('type', 'main');
    }

    public function homePhoto()
    {
        return $this->hasOne(ProductImage::class)->where('type', 'home');
    }
    public function related_product_variations()
    {
        return $this->hasMany(ProductVariation::class);
    }



    public function relatedVariations()
    {
        return $this->belongsToMany(ProductVariationOption::class, 'related_product_variations', 'product_id', 'variation_option_id');
    }

    public function vendors()
    {
        return $this->belongsToMany(Vendor::class, 'vendor_product');
    }



}
