<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProductPrice extends Model
{
    use HasFactory;
    protected $guarded = [];

    protected $casts = [
        'price' => 'array',
    ];

    public function getSevenDayTotals()
    {
        // Extract prices from the 'price' attribute
        $prices = $this->price;
        
        // Function to clean the price and convert to float
        $cleanPrice = function ($price) {
            $price = str_replace(' €', '', $price);
            $price = str_replace(',', '.', $price);
            return (float)$price;
        };

        // Split the array into chunks of 7 prices
        $chunks = array_chunk($prices, 7);
        // dd($chunks);
        // Calculate the total for each 7-day chunk
        $totals = [];
        foreach ($chunks as $chunk) {
            $total = 0;
            foreach ($chunk as $price) {
                // dd($cleanPrice($price));
                $total += $cleanPrice($price);
            }
            $totals[] = $total;
        }

        return $totals;
    }

    public function weekDays(){
        $prices = $this->price;
        $chunks = array_chunk($prices, 7);
        return $chunks;
    }
}
