<?php 
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductVariation extends Model
{
    protected $fillable = [
        'product_id', 'size_id', 'weight', 'status','variation_id',
        'length', 'width', 'height', 'volume', 'max_load'
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function size()
    {
        return $this->belongsTo(Size::class);
    }

    public function options()
    {
        return $this->hasMany(ProductVariationOption::class, 'variation_id');
    }
    public function variation() { return $this->belongsTo(Variation::class, 'variation_id'); }

}
