<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ProductVariationOption extends Model
{
    protected $fillable = ['variation_id', 'color_id', 'quantity', 'sku'];

    public function variation()
    {
        return $this->belongsTo(ProductVariation::class, 'variation_id');
    }

    public function color()
    {
        return $this->belongsTo(Color::class,'color_id');
    }

    public function vendorQuantities()
    {
        return $this->hasMany(VendorProductQuantity::class, 'product_variation_option_id');
    }
}
