<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RelatedProductVariation extends Model
{
    protected $fillable = [
        'product_id',
        'variation_option_id',
    ];

    protected $guarded = [];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function variationOption()
    {
        return $this->belongsTo(ProductVariationOption::class, 'variation_option_id');
    }
}
