<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Vendor extends Authenticatable
{
    use HasFactory, Notifiable;

    protected $fillable = [
         'title', 'first_name', 'last_name', 'email', 'password',
        'profile_image', 'country_code', 'number', 'street', 'zip_code', 
        'city', 'country', 'status', 'business_model', 'size_of_location',
        'new_in_business', 'business_type', 'contact_person', 'tax_number',
        'tax_id', 'bank_name', 'account_owner', 'account_number', 'bic_number',
        'iban_number','commission_rate','payout_dates'
    ];

    protected $hidden = [
        'password',
        'remember_token',
    ];
    public function workingHours()
    {
        return $this->hasMany(VendorWorkingHour::class);
    }

    public function holidays()
    {
        return $this->hasMany(VendorHoliday::class);
    }

    protected $casts = [
        'is_deleted' => 'boolean',
         'commission_rate' => 'array',
         'payout_dates' => 'array',
    ];

    // Accessor for full name
    public function getFullNameAttribute()
    {
        return "{$this->first_name} {$this->last_name}";
    }

    protected static function boot()
    {
        parent::boot();

        static::creating(function ($vendor) {
            $vendor->spo_id = 'SPO' . str_pad(Vendor::count() + 1, 5, '0', STR_PAD_LEFT);
        });
    }
    public function products()
    {
        return $this->belongsToMany(Product::class, 'vendor_product');
    }
    public function disabledVariants()
    {
        return $this->belongsToMany(ProductVariation::class, 'vendor_disabled_variants');
    }

    public function productQuantities()
    {
        return $this->hasMany(VendorProductQuantity::class);
    }
}