<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VendorProductQuantity extends Model
{
    protected $table = 'vendors_product_quantities';

    protected $fillable = [
        'vendor_id',
        'product_variation_option_id',
        'quantity',
        'sku'
       
    ];

    public function vendor()
    {
        return $this->belongsTo(Vendor::class);
    }

    public function variationOption()
    {
        return $this->belongsTo(ProductVariationOption::class, 'product_variation_option_id');
    }

    public function product()
    {
        return $this->variationOption->variation->product;
    }
}
